<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysRulesParser
{
    private $query = null;
    private $count = 1;
    
    protected $operators = array (
        'equal'            => array ('accept_values' => true,  'apply_to' => ['string', 'integer', 'datetime']),
        'not_equal'        => array ('accept_values' => true,  'apply_to' => ['string', 'integer', 'datetime']),
        'in'               => array ('accept_values' => true,  'apply_to' => ['string', 'integer', 'datetime']),
        'not_in'           => array ('accept_values' => true,  'apply_to' => ['string', 'integer', 'datetime']),
        'less'             => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'less_or_equal'    => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'greater'          => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'greater_or_equal' => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'between'          => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'not_between'      => array ('accept_values' => true,  'apply_to' => ['integer', 'datetime']),
        'begins_with'      => array ('accept_values' => true,  'apply_to' => ['string']),
        'not_begins_with'  => array ('accept_values' => true,  'apply_to' => ['string']),
        'contains'         => array ('accept_values' => true,  'apply_to' => ['string']),
        'not_contains'     => array ('accept_values' => true,  'apply_to' => ['string']),
        'ends_with'        => array ('accept_values' => true,  'apply_to' => ['string']),
        'not_ends_with'    => array ('accept_values' => true,  'apply_to' => ['string']),
        'is_empty'         => array ('accept_values' => false, 'apply_to' => ['string']),
        'is_not_empty'     => array ('accept_values' => false, 'apply_to' => ['string']),
        'is_null'          => array ('accept_values' => false, 'apply_to' => ['string', 'integer', 'datetime']),
        'is_not_null'      => array ('accept_values' => false, 'apply_to' => ['string', 'integer', 'datetime'])
    );
    
    protected $operator_sql = array (
        'equal'            => array ('operator' => '='),
        'not_equal'        => array ('operator' => '!='),
        'in'               => array ('operator' => 'IN'),
        'not_in'           => array ('operator' => 'NOT IN'),
        'less'             => array ('operator' => '<'),
        'less_or_equal'    => array ('operator' => '<='),
        'greater'          => array ('operator' => '>'),
        'greater_or_equal' => array ('operator' => '>='),
        'between'          => array ('operator' => 'BETWEEN'),
        'not_between'      => array ('operator' => 'NOT BETWEEN'),
        'begins_with'      => array ('operator' => 'LIKE',     'prepend'  => '%'),
        'not_begins_with'  => array ('operator' => 'NOT LIKE', 'prepend'  => '%'),
        'contains'         => array ('operator' => 'LIKE',     'append'  => '%', 'prepend' => '%'),
        'not_contains'     => array ('operator' => 'NOT LIKE', 'append'  => '%', 'prepend' => '%'),
        'ends_with'        => array ('operator' => 'LIKE',     'append' => '%'),
        'not_ends_with'    => array ('operator' => 'NOT LIKE', 'append' => '%'),
        'is_empty'         => array ('operator' => '='),
        'is_not_empty'     => array ('operator' => '!='),
        'is_null'          => array ('operator' => 'NULL'),
        'is_not_null'      => array ('operator' => 'NOT NULL')
    );
    
	public function getResult($rules, &$query, $column = 'ftq.response_id')
	{
	    $result = "";
	    $params = array();
	    $conditions = json_decode(utf8_encode($rules), true);
	    $this->query = $query;
	    
	    if($conditions && array_key_exists('condition', $conditions)) 
	    {
	        $global_bool_operator = in_array($conditions['condition'], array('AND', 'OR')) ? $conditions['condition'] : 'AND';
	        $total = count($conditions['rules']);
	        
	        foreach($conditions['rules'] as $index => $rule) 
	        {
// 	            if(array_key_exists('condition', $rule)) 
// 	            {
// 	                $result .= $this->parseGroup($rule, $params);
// 	                $total--;
	                
// 	                if($counter < $total)
// 	                {
// 	                    $result .= " $global_bool_operator ";
// 	                }
// 	            } 
// 	            else 
// 	            {
                    $result = $this->parseRule($rule, $params, $column);
	                $total--;
	                
// 	                if($counter < $total)
// 	                {
// 	                    $result .= " $global_bool_operator ";
// 	                }

                    if($global_bool_operator == 'AND')
                    {
                        $this->query->join('INNER', '#__survey_response_details AS t'. $this->count . ' ON ' . $result);
                    }
//                     else
//                     {
//                         $this->query->unionAll('SELECT response_id FROM #__survey_response_details AS t'. $this->count . ' WHERE ' . $result);
//                     }
                    
                    $this->count++;
// 	            }
	        }
	    }
	    
	    return $result;
	}
	
	function parseGroup($rule, &$param) 
	{
	    $parseResult = "(";
	    $bool_operator = in_array($rule['condition'], array('AND', 'OR')) ? $rule['condition'] : 'AND';
	    $counter = 0;
	    $total = count($rule['rules']);
	    
	    foreach($rule['rules'] as $i => $r) 
	    {
	        if(array_key_exists('condition', $r)) 
	        {
	            $parseResult .= "\n".$this->parseGroup($r, $param);
	        } 
	        else 
	        {
	            $parseResult .= $this->parseRule($r, $param);
	            $total--;
	            
	            if($counter < $total && !empty($parseResult))
	            {
	                $parseResult .= " ".$bool_operator." ";
	            }
	        }
	    }
	    
	    return $parseResult.")";
	}
	
	function parseRule($rule, &$param, $column) 
	{
	    if(!isset($this->operators[$rule['operator']]) || !in_array($rule['type'], $this->operators[$rule['operator']]['apply_to'])) return '';
	    $parseResult =
	   	    't' . $this->count . '.question_id = ' . (int) $rule['field'] . ' AND ' .
	   	    't' . $this->count . '.answer_id '. $this->operator_sql[$rule['operator']]['operator'] .' ' . (int) $rule['value'] .' AND '.
	   	    't' . $this->count . '.response_id = '. $column;
	    
	    return $parseResult;
	}
}