<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/survey.php';

class CommunitySurveysModelImport extends CommunitySurveysModelSurvey
{
    public function importSurvey(SimpleXMLElement $xml)
    {
    	if(empty($xml->title) || empty($xml->questions->item) || empty($xml->catid))
    	{
    		return false;
    	}
    	
    	$app 						= JFactory::getApplication();
    	$input 						= JFilterInput::getInstance(null, null, 1, 1);
    	$user 						= JFactory::getUser();
    	$db 						= JFactory::getDbo();
    	$survey 					= new stdClass();
    	$updates 					= array();
    	$count 						= 0;

    	$survey->title 				= $input->clean($xml->title, 'html');
    	$survey->description		= $input->clean($xml->description, 'html');
    	$survey->endtext			= $input->clean($xml->endtext, 'html');
    	$survey->custom_header		= $input->clean($xml->custom_header, 'html');
    	$survey->catid 				= $input->clean($xml->catid, 'int');
    	$survey->access 			= $input->clean($xml->access, 'uint');
    	$survey->private			= $input->clean($xml->private, 'uint');
    	$survey->max_responses		= $input->clean($xml->max_responses, 'uint');
    	$survey->redirect_url		= $input->clean($xml->redirect_url, 'string');
    	$survey->publish_up 		= $input->clean($xml->publish_up, 'string');
    	$survey->publish_down 		= $input->clean($xml->publish_down, 'string');
    	$survey->metadesc 			= $input->clean($xml->metadesc, 'string');
    	$survey->metakey 			= $input->clean($xml->metakey, 'string');
    	$survey->language 			= $input->clean($xml->language, 'string');
    	$survey->alias 				= !empty($xml->alias) ? $input->clean($xml->alias, 'string') : JFilterOutput::stringURLUnicodeSlug($xml->title);
    	$survey->restrictions		= !empty($xml->restrictions) ? explode(',' ,$input->clean($xml->restrictions, 'string')) : array();
    	$survey->created_by			= 0;

    	$survey->attribs 			= json_decode($xml->attribs, true);
    	$survey->metadata 			= json_decode($xml->metadata, true);
    	
    	try 
    	{
    		$data = (array) $survey;
    		list($title, $alias) = $this->generateNewTitle($data['catid'], $data['alias'], $data['title']);
    		$data['title'] = $title;
    		$data['alias'] = $alias;
    		
    		if(!parent::save($data))
    		{
    			$app->enqueueMessage(parent::getError());
    			return false;
    		}
    		
    		$survey->id = (int)$this->getState($this->getName() . '.id');
    		if(!$survey->id)
    		{
    			$app->enqueueMessage(parent::getError());
    			return false;
    		}
    		
    		/**************************** PAGES *******************************/
    		$survey->pages = array();
    		$survey->questions = array();
    		$sortOrder = 0;
    		
    		foreach ($xml->pages->item as $i=>$nodePg)
    		{
    			$page = new stdClass();
    			$page->sort_order = $sortOrder++;
    			$page->sid = $survey->id;
    			$page->title = $nodePg->title;
    			
    			// insert new page only if this a new survey operation
    			if(!$count)
    			{
	    			if(!$db->insertObject('#__survey_pages', $page, 'id'))
	    			{
	    				return false;
	    			}
	    			
	    			$page->id = $db->insertid();
	    			$page->old_id = $input->clean($nodePg->id, 'uint');
    			}
    			// otherwise set oldid as current id to mimic the same page is being used
    			else 
    			{
    				$page->id = $input->clean($nodePg->id, 'uint');
    				
    				if(!$db->updateObject('#__survey_pages', $page, 'id'))
    				{
    					return false;
    				}
    				
    				$page->old_id = $input->clean($nodePg->id, 'uint');
    			}
    			
    			$survey->pages[] = $page;
    		}
    		/**************************** PAGES *******************************/
    		
    		/*************************** QUESTIONS ****************************/
    		foreach ($xml->questions->item as $nodeQn)
    		{
    			$question 					= new stdClass();
    			$question->title 			= $input->clean($nodeQn->title, 'html');
    			$question->description 		= $input->clean($nodeQn->description, 'html');
    			$question->question_type 	= $input->clean($nodeQn->question_type, 'int');
    			$question->page_number 		= $input->clean($nodeQn->page_number, 'uint');
    			$question->sort_order 		= $input->clean($nodeQn->sort_order, 'uint');
    			$question->mandatory 		= $input->clean($nodeQn->mandatory, 'uint');
    			$question->custom_choice 	= $input->clean($nodeQn->custom_choice, 'uint');
    			$question->orientation 		= $input->clean($nodeQn->orientation, 'word');
    			$question->min_selections 	= $input->clean($nodeQn->min_selections, 'uint');
    			$question->max_selections 	= $input->clean($nodeQn->max_selections, 'uint');
    			$question->survey_id 		= $survey->id;
    			$survey->created_by 		= $user->id;
    			
    			foreach ($survey->pages as $page)
    			{
    				if($page->old_id == $question->page_number)
    				{
    					$question->page_number = $page->id;
    				}
    			}
    			
    			if(!$db->insertObject('#__survey_questions', $question, 'id'))
    			{
    				return false;
    			}
    			
    			$question->id = $db->insertid();
    			$question->old_id = $input->clean($nodeQn->id, 'uint');;

    			/*************************** ANSWERS ****************************/
    			if(empty($nodeQn->answers->item))
    			{
    				continue;
    			}
    			
    			$question->answers = array();
    			
    			foreach ($nodeQn->answers->item as $nodeAn)
    			{
    				$answer 				= new stdClass();
    				$answer->answer_label	= $input->clean($nodeAn->title, 'html');
    				$answer->survey_id 		= $survey->id;
    				$answer->question_id 	= $question->id;
    				$answer->answer_type 	= $input->clean($nodeAn->answer_type, 'word');
    				$answer->sort_order 	= $input->clean($nodeAn->sort_order, 'uint');
    				$answer->image 			= $input->clean($nodeAn->image, 'cmd');
    				
    				if(!$db->insertObject('#__survey_answers', $answer, 'id'))
    				{
    					return false;
    				}
    				
    				$answer->id 			= $db->insertid();
    				$answer->old_id 		= $input->clean($nodeAn->id, 'uint');
    				$question->answers[] 	= $answer;
    			}
    			/*************************** ANSWERS ****************************/

    			/*************************** COLUMNS ****************************/
    			if(!empty($nodeQn->columns->item))
    			{
	    			$question->columns = array();
	    			
	    			foreach ($nodeQn->columns->item as $nodeAn)
	    			{
	    				$answer 				= new stdClass();
	    				$answer->answer_label	= $input->clean($nodeAn->title, 'html');
	    				$answer->survey_id 		= $survey->id;
	    				$answer->question_id 	= $question->id;
	    				$answer->answer_type 	= $input->clean($nodeAn->answer_type, 'word');
	    				$answer->sort_order 	= $input->clean($nodeAn->sort_order, 'uint');
	    				$answer->image 			= $input->clean($nodeAn->image, 'cmd');
	    				
	    				if(!$db->insertObject('#__survey_answers', $answer, 'id'))
	    				{
	    					return false;
	    				}
	    				
	    				$answer->id 			= $db->insertid();
	    				$answer->old_id 		= $input->clean($nodeAn->id, 'uint');
	    				$question->columns[] 	= $answer;
	    			}
    			}
    			/*************************** COLUMNS ****************************/
    			
    			$survey->questions[$question->old_id] = $question;
    		}
    		/*************************** QUESTIONS ****************************/
    		
    		/***************************** RULES ******************************/
    		foreach ($xml->questions->item as $nodeQn)
    		{
    			$oldQnId = $input->clean($nodeQn->id, 'uint');
    			if(empty($survey->questions[$oldQnId]))
    			{
    				continue;
    			}
    			
    			$question = $survey->questions[$oldQnId];
    			
    			foreach ($nodeQn->rules->item as $rule)
    			{
    				$ruleContent 			= new stdClass();
    				$ruleContent->name 		= $input->clean($rule->name, 'string');
    				$ruleContent->finalize 	= $input->clean($rule->finalize, 'uint');
    				$ruleContent->answer_id = $input->clean($rule->answer_id, 'uint');
    				$ruleContent->column_id = $input->clean($rule->column_id, 'uint');
    				$ruleContent->page 		= $input->clean($rule->page, 'uint');
    				$ruleContent->question 	= $input->clean($rule->question, 'uint');
    				
    				if(!empty($ruleContent->answer_id))
    				{
    					foreach ($question->answers as $answer)
    					{
    						if($answer->old_id == $ruleContent->answer_id)
    						{
    							$ruleContent->answer_id = $answer->id;
    							break;
    						}
    					}
    				}
    				
    				if(!empty($ruleContent->column_id))
    				{
    					foreach ($question->columns as $column)
    					{
    						if($column->old_id == $ruleContent->column_id)
    						{
    							$ruleContent->column_id = $column->id;
    							break;
    						}
    					}
    				}
    				
    				if(!empty($ruleContent->page))
    				{
    					foreach ($survey->pages as $page)
    					{
    						if($page->old_id == $ruleContent->page)
    						{
    							$ruleContent->page = $page->id;
    							break;
    						}
    					}
    				}
    				
    				if(!empty($ruleContent->question))
    				{
    					$ruleContent->question = $survey->questions[$ruleContent->question]->id;
    				}
    				
    				$newRule = new stdClass();
    				$newRule->survey_id = $survey->id;
    				$newRule->question_id = $question->id;
    				$newRule->rulecontent = json_encode($ruleContent);
    				
    				if(!$db->insertObject('#__survey_rules', $newRule))
    				{
    					return false;
    				}
    			}
    		}
    		/***************************** RULES ******************************/
    		
    		return true;
    	}
    	catch (Exception $e)
    	{
    		$app->enqueueMessage($e->getMessage());
    		return false;
    	}
    	catch (Exception $e)
    	{
    		return false;
    	}
    	
    	return false;
    }
    
    private function xml2array ( $xmlObject, $out = array () )
    {
        foreach ( (array) $xmlObject as $index => $node )
        {
            $out[$index] = ( is_object ( $node ) ) ? $this->xml2array ( $node ) : $node;
        }
    
        return $out;
    }
}