<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JLoader::register('CommunitySurveysHelper', JPATH_ADMINISTRATOR . '/components/com_communitysurveys/helpers/communitysurveys.php');

class CommunitySurveysModelLanguage extends JModelAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	protected $_translations = array();
	public $typeAlias = 'com_communitysurveys.language';
	
	public function getSurvey()
	{
	    $app = JFactory::getApplication();
	    $surveyId = $app->input->getInt('survey_id', 0);
	    if(!$surveyId) 
	    {
	        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
	    }
	    
	    $db = $this->getDbo();
	    $query = $db->getQuery(true)->select('id, title, alias, language')->from('#__survey_surveys')->where('id = ' . $surveyId);
	    $db->setQuery($query);
	    $survey = $db->loadObject();
	    
	    return $survey;
	}
	
	/**
	 * Method to save the form data.
	 *
	 * @param   array  The form data.
	 *
	 * @return  boolean  True on success.
	 */
	public function save($data)
	{
	    if(empty($data['id']))
	    {
	        $data['created'] = JFactory::getDate()->toSql();
	        if(!$data['created_by'])
	        {
	            $data['created_by'] = JFactory::getUser()->id;
	        }
	    }
	    
	    if(parent::save($data))
	    {
	        $db = JFactory::getDbo();
	        $id = (int) $this->getState($this->getName() . '.id');
	        $date = JFactory::getDate()->toSql();
	        $surveyId = (int) $data['survey_id'];
	        
	        $insertQuery = $db->getQuery(true)
	        ->insert('#__survey_translations')
	        ->columns('language_id, item_id, parent_id, item_type, created_by, created, published');
	        $insertQueryValues = array();
	        
	        $insertQueryValues[] = array(
	            $db->q($id).','.$surveyId.',0,'.$db->q(CS_TRANSLATION_SURVEY_TITLE).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'), // survey title
	            $db->q($id).','.$surveyId.',0,'.$db->q(CS_TRANSLATION_SURVEY_DESC).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'), // survey description
	            $db->q($id).','.$surveyId.',0,'.$db->q(CS_TRANSLATION_SURVEY_ENDTEXT).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'), // end of survey message
	            $db->q($id).','.$surveyId.',0,'.$db->q(CS_TRANSLATION_SURVEY_HEADER).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1')  // custom page header
	        );
	        
	        // page title
	        $insertQueryValues[] = $db->getQuery(true)
	        ->select($db->q($id).',a.id,0,'.$db->q(CS_TRANSLATION_PAGE_TITLE).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'))
	        ->from('#__survey_pages a')
	        ->where('sid = ' . $surveyId);
	        
	        // question title
	        $insertQueryValues[] = $db->getQuery(true)
	        ->select($db->q($id).',a.id,0,'.$db->q(CS_TRANSLATION_QUESTION_TITLE).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'))
	        ->from('#__survey_questions a')
	        ->where('survey_id = ' . $surveyId);
	        
	        // question description
	        $insertQueryValues[] = $db->getQuery(true)
	        ->select($db->q($id).',a.id,a.id,'.$db->q(CS_TRANSLATION_QUESTION_DESC).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'))
	        ->from('#__survey_questions a')
	        ->where('survey_id = ' . $surveyId);
	        
	        // question answers
	        $insertQueryValues[] = $db->getQuery(true)
	        ->select($db->q($id).',a.id,a.question_id,'.$db->q(CS_TRANSLATION_ANSWER_TITLE).','.$db->q($data['created_by']).','.$db->q($date).','.$db->q('1'))
	        ->from('#__survey_answers a')
	        ->where('survey_id = ' . $surveyId)
	        ->where('answer_type != ' . $db->q('text'));
	        
	        foreach ($insertQueryValues as $insertQueryValue)
	        {
	            $insertQuery->clear('values')->values($insertQueryValue);
	            $db->setQuery($insertQuery->__toString() . ' ON DUPLICATE KEY UPDATE #__survey_translations.id = #__survey_translations.id');
	            $db->execute();
	        }
	    }
	    
	    return true;
	}
	
	public function delete(&$pks)
	{
	    $return = parent::delete($pks);
	    if($return)
	    {
	        $db = $this->getDbo();
	        $query = $db->getQuery(true)
	           ->delete('#__survey_translations')
	           ->where('language_id IN (' . implode(',', $pks) . ')');
	        $db->setQuery($query);
	        $db->execute();
	    }
	    
	    return $return;
	}

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param   type      The table type to instantiate
	 * @param   string    A prefix for the table class name. Optional.
	 * @param   array     Configuration array for model. Optional.
	 *
	 * @return  JTable    A database object
	 */
	public function getTable($type = 'Language', $prefix = 'CommunitySurveysTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array      $data        Data for the form.
	 * @param   boolean    $loadData    True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_communitysurveys.language', 'language', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		return $form;
	}
	
	public function getSurveyTranslations($surveyId, $language)
	{
	    if(!isset($this->_translations[$language]))
	    {
	        try
	        {
    	        $db = $this->getDbo();
    	        $query = $db->getQuery(true)
    	           ->select('a.id, a.language_id, a.item_id, a.item_type, a.parent_id, a.translation, a.created_by, a.created, a.published')
    	           ->from('#__survey_translations a')
    	           ->join('inner', '#__survey_languages l on l.id = a.language_id')
    	           ->where('l.survey_id = ' . $surveyId)
    	           ->where('l.language = ' . $db->q($language))
    	           ->where('a.published = 1')
    	           ->where('l.published = 1');
    	        $db->setQuery($query);
    	        $this->_translations[$language] = $db->loadObjectList();
	        }
	        catch (Exception $e)
	        {
                $this->_translations[$language] = false;
	        }
	    }
	    
	    return $this->_translations[$language];
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$app = JFactory::getApplication();
		$data = $app->getUserState('com_communitysurveys.edit.language.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}
		
		if(is_array($data) && empty($data['survey_id']))
		{
    		$app = JFactory::getApplication();
    		$data['survey_id'] = $app->input->getInt('survey_id', 0);
		}
		else if(is_object($data) && empty($data->survey_id)) 
		{
		    $app = JFactory::getApplication();
		    $data->survey_id = $app->input->getInt('survey_id', 0);
		}

		$this->preprocessData('com_communitysurveys.language', $data);
		
		return $data;
	}

	/**
	 * Custom clean the cache of com_communitysurveys and content modules
	 */
	protected function cleanCache($group = null, $client_id = 0)
	{
		parent::cleanCache('com_communitysurveys');
	}
}
