<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/reportsbase.php';
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/responses.php';

class CommunitySurveysModelReports extends CommunitySurveysModelReportsBase
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	protected function populateState($ordering = null, $direction = null)
	{
		parent::populateState($ordering, $direction);
		
		$app = JFactory::getApplication();
		$surveyId = $app->input->getInt('id', 0);
		$this->context = 'com_communitysurveys.reports.'.$surveyId;
		
		$startDate = $app->getUserStateFromRequest($this->context . '.filter.start_date', 'start_date');
		$this->setState('consolidated.start_date', $startDate);
		
		$endDate = $app->getUserStateFromRequest($this->context . '.filter.end_date', 'end_date');
		$this->setState('consolidated.end_date', $endDate);
		
		$numCustomAnswers = $app->getUserStateFromRequest($this->context . '.filter.num_custom_answers', 'num_custom_answers', 5, 'uint');
		$this->setState('consolidated.num_custom_answers', $numCustomAnswers);
		
		$conditions = $app->getUserStateFromRequest($this->context . '.filter.conditions', 'filter_conditions', '', 'string');
		$this->setState('advancedfilter.conditions', $conditions);
	}
	
	public function getItem($pk = null)
	{
		return parent::getItem($pk);
	}
	
	public function getStats($pk = null)
	{
		$db = JFactory::getDbo();
		$stats = new stdClass();
		$pk = (!empty($pk)) ? $pk : (int) $this->getState($this->getName() . '.id');
		
		try 
		{
			$query = $db->getQuery(true)
				->select('count(*)')
				->from('#__survey_responses')
				->where('survey_id = '.$pk.' and state = 1 and completed >= created');
			
			$db->setQuery($query);
			$stats->completed = (int) $db->loadResult();
			
			$query = $db->getQuery(true)
				->select('count(*)')
				->from('#__survey_responses')
				->where('survey_id = '.$pk.' and state = 1');
			
			$db->setQuery($query);
			$stats->responses = (int) $db->loadResult();
			
			$query = $db->getQuery(true)
				->select('count(distinct(browser_info))')
				->from('#__survey_tracking')
				->where('post_id in (select id from #__survey_responses where survey_id = '.$pk.') and post_type = 1');
			
			$db->setQuery($query);
			$stats->browsers = (int) $db->loadResult();
			
			$query = $db->getQuery(true)
				->select('count(distinct(country))')
				->from('#__survey_tracking')
				->where('post_id in (select id from #__survey_responses where survey_id = '.$pk.') and post_type = 1');
			
			$db->setQuery($query);
			$stats->countries = (int) $db->loadResult();
			
			$query = $db->getQuery(true)
				->select('count(distinct(os))')
				->from('#__survey_tracking')
				->where('post_id in (select id from #__survey_responses where survey_id = '.$pk.') and post_type = 1');
			
			$db->setQuery($query);
			$stats->oses = (int) $db->loadResult();
			
			$query = $db->getQuery(true)
				->select('r.created_by, r.created, r.completed')
				->from('#__survey_responses r');
			
			$query->select('t.ip_address, c.country_name, t.city, t.browser_name, t.browser_version, t.os, t.browser_info')
				->join('LEFT', '#__survey_tracking AS t ON t.post_id = r.id AND t.post_type = 1')
				->join('LEFT', '#__corejoomla_countries AS c ON c.country_code = t.country AND c.language = '.$db->q('*'))
                ->where('t.post_type = 1')
                ->where('t.post_id in (select id from #__survey_responses where survey_id = '.$pk.')');
			
			$query = $db->getQuery(true)
				->select('count(*) as posts, date(created) as cdate')
				->from('#__survey_responses')
				->where('survey_id = '.$pk.' and state = 1')
				->group('date(created) asc');
				
			$db->setQuery($query);
			$stats->daywise = $db->loadAssocList('cdate');

			$query = $db->getQuery(true)
				->select('count(*) as posts, a.country, c.country_name')
				->from('#__survey_tracking AS a')
				->join('left', '#__corejoomla_countries AS c ON a.country = c.country_code')
				->where('a.post_type = 1')
				->where('a.post_id in (select id from #__survey_responses where survey_id = '.$pk.')')
				->group('country, country_name');
			
			$db->setQuery($query);
			$stats->countrywise = $db->loadAssocList('country');
		}
		catch (Exception $e)
		{
		    JFactory::getApplication()->enqueueMessage($e->getMessage());
			return false;
		}
			
		return $stats;
	}
	
	public function getResponses($surveyId = null)
	{
		$report = new stdClass();
		$surveyId = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		
		$config = array();
		$config['filter_fields'] = array(
				'id', 'a.id',
				'survey_id', 'a.survey_id',
				'created', 'a.created',
				'created_by', 'a.created_by',
				'completed', 'a.completed',
				'ip_address', 'a.ip_address',
				'state', 'a.state',
				'ip_address', 't.ip_address',
				'country', 't.country',
				'city', 't.city',
				'browser', 't.browser_name',
				'os', 't.os',
				'author_id',
				'response_status'
		);
		
		$model	= JModelLegacy::getInstance( 'responses', 'CommunitySurveysModel', $config );
		$model->getState(); // access the state first so that it can be modified
		
		$model->setState('survey_id', $surveyId);
		$model->setState('filter.junk', false);
// 		$model->setState('list.ordering', 'a.id');
// 		$model->setState('list.direction', 'desc');
		
		$report->responses 		= $model->getItems();
		$report->pagination 	= $model->getPagination();
		$report->state 			= $model->getState();
		$report->authors       	= $model->getAuthors();
		$report->filterForm    	= $model->getFilterForm();
		$report->activeFilters 	= $model->getActiveFilters();
		
		JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
		$questionsModel = JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
		
		$questionsModel->getState();
		$questionsModel->setState('filter.survey_id', $surveyId);
		$questionsModel->setState('filter.category_id', null);
		$questionsModel->setState('filter.page_id', 0);
		$questionsModel->setState('filter.question_id', null);
		$questionsModel->setState('filter.unique', false);
		$questionsModel->setState('filter.response_id', false);
		$questionsModel->setState('list.ordering', 'p.sort_order asc, a.sort_order');
		$questionsModel->setState('list.direction', 'asc');
		$questionsModel->setState('list.limit', 0);
		$report->questions = $questionsModel->getItems();
		$rules = array();
		
		foreach ($report->questions as $question)
		{
		    if(!in_array($question->question_type, array(CS_CHOICE_RADIO, CS_CHOICE_CHECKBOX, CS_CHOICE_SELECT)))
		    {
		        continue;
		    }
		    
		    $rule = new stdClass();
		    $rule->id = $question->id;
		    $rule->label = CjLibUtils::escape($question->title);
		    $rule->type = 'integer';
		    $rule->input = 'select';
		    $rule->values = array();
		    
		    foreach ($question->answers as $answer)
		    {
		        $rule->values[$answer->id] = $answer->title;
		    }
		    
		    $rules[] = $rule;
		}
		
		$report->filter_rules = json_encode($rules);
		
		return $report;
	}
	
	public function getResponse($surveyId = null)
	{
		$surveyId = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		$pk = (int) $this->getState('response.id');
		
		if(!$surveyId || !$pk)
		{
			return false;
		}
		
		JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
		$questionsModel = JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );

		$questionsModel->getState();
		$questionsModel->setState('filter.survey_id', $surveyId);
		$questionsModel->setState('filter.category_id', null);
		$questionsModel->setState('filter.page_id', 0);
		$questionsModel->setState('filter.question_id', null);
		$questionsModel->setState('filter.unique', false);
		$questionsModel->setState('filter.response_id', $pk);
		$questionsModel->setState('list.ordering', 'p.sort_order asc, a.sort_order');
		$questionsModel->setState('list.direction', 'asc');
		$questionsModel->setState('list.limit', 0);
		$questions = $questionsModel->getItems();

		return $questions;
	}
	
	public function getConsolidatedReport($surveyId = null)
	{
		$db               = JFactory::getDbo();
		$surveyId         = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		$params           = JComponentHelper::getParams('com_communitysurveys');
		$userDisplayName  = $params->get('user_display_name', 'name');
		$numCustomAnswers = (int) $this->getState('consolidated.num_custom_answers', 5);
		
		JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
		$questionsModel = JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
		
		$questionsModel->getState();
		$questionsModel->setState('filter.survey_id', $surveyId);
		$questionsModel->setState('filter.category_id', null);
		$questionsModel->setState('filter.page_id', 0);
		$questionsModel->setState('filter.question_id', null);
		$questionsModel->setState('filter.unique', false);
		$questionsModel->setState('filter.response_id', false);
		$questionsModel->setState('list.ordering', 'p.sort_order asc, a.sort_order');
		$questionsModel->setState('list.direction', 'asc');
		$questionsModel->setState('list.limit', 0);
		
		$data = new stdClass();
		$rules = array();
		$data->questions = $questionsModel->getItems();
		
		if (empty($data->questions))
		{
		    return false;
		}
		
		// Build the filter rules show conditional filters UI
		foreach ($data->questions as $question)
		{
		    if(!in_array($question->question_type, array(CS_CHOICE_RADIO, CS_CHOICE_CHECKBOX, CS_CHOICE_SELECT)))
		    {
		        continue;
		    }
		    
		    $rule = new stdClass();
		    $rule->id = $question->id;
		    $rule->label = CjLibUtils::escape($question->title);
		    $rule->type = 'integer';
		    $rule->input = 'select';
		    $rule->values = array();
		    
		    foreach ($question->answers as $answer)
		    {
		        $rule->values[$answer->id] = $answer->title;
		    }
		    
		    $rules[] = $rule;
		}
		
		$data->filter_rules = json_encode($rules);
		// End filter rules build
		
		$filterQuery = $db->getQuery(true)
			->select('ftq.question_id, ftq.answer_id, ftq.column_id, count(*) as votes')
			->from('#__survey_response_details AS ftq')
			->where('ftq.question_id in (select xt.id from #__survey_questions AS xt where xt.survey_id='.$surveyId.')')
			->group('ftq.question_id, ftq.answer_id, ftq.column_id')
			->order('ftq.question_id');
		
		$subQuery = $db->getQuery(true)
			->select('x.id')
			->from('#__survey_responses AS x')
			->where('x.survey_id='.$surveyId.' and x.completed >= x.created and x.state = 1');
		
		$startDate = $this->getState('consolidated.start_date', null);
		if($startDate)
		{
			$startDate = JFactory::getDate($startDate)->toSql();
			$subQuery->where('x.created >= '.$db->q($startDate));
		}

		$endDate = $this->getState('consolidated.end_date', null);
		if($endDate)
		{
			$endDate = JFactory::getDate($endDate)->toSql();
			$subQuery->where('x.created <= '.$db->q($endDate));
		}
		
		$filterQuery->where('ftq.response_id in ('.$subQuery->__toString().')');
		
		// filter conditions
		require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/helpers/rulesparser.php';
		$conditions = $this->getState('advancedfilter.conditions', 'string');
		$rulesParser = new CommunitySurveysRulesParser();
		$rulesParser->getResult($conditions, $filterQuery);
		
// 		echo $query->dump();
// 		jexit();
		$db->setQuery($filterQuery);
		
		try
		{
			$responsesList =  $db->loadObjectList();
			foreach ($data->questions as &$question)
			{
				$question->votes = 0;
				$question->responses = array();
				$question->textResponses = array();
			}
			
			if(empty($responsesList))
			{
				return $data;
			}
			
			foreach ($data->questions as &$question)
			{
				foreach ($responsesList as $num=>&$response)
				{
					if($response->question_id == $question->id)
					{
						$question->responses[] = $response;
						$question->votes = $question->votes + $response->votes;
						unset($responsesList[$num]);
					}
				}
				
				$query = $db->getQuery(true)
				    ->select('a.id, a.response_id, a.question_id, a.answer_id, a.column_id, a.free_text, u.'.$userDisplayName.' AS author')
				    ->from('#__survey_response_details AS a')
				    ->join('LEFT', '#__survey_responses AS r ON r.id = a.response_id')
				    ->join('LEFT', '#__users AS u ON u.id = r.created_by')
				    ->where('a.question_id = '.$question->id.' AND a.free_text IS NOT NULL');
				
			    if($startDate || $endDate || !empty($conditions))
			    {
			        $filterQuery->clear('select')->clear('group')->select('ftq.response_id');
			        $query->where('a.response_id IN (' . $filterQuery->__toString() . ')');
			    }

			    $db->setQuery($query, 0, $numCustomAnswers);
			    $question->textResponses = $db->loadObjectList();
			}
			
			return $data;
		}
		catch (Exception $e)
		{
			JFactory::getApplication()->enqueueMessage( $e->getMessage() . '<br><br> Error code: 10251<br>query: ' . $query . '<br><br>' );
			return false;
		}
		
		return false;
	}
	
	public function createPdfReport($surveyId, $responseId = 0)
	{
		$filename	= JPATH_ROOT.'/media/com_communitysurveys/attachments/responses/'.$surveyId.'_'.$responseId.'.pdf';
		if(file_exists($filename))
		{
			return $filename;
		}
	
		$return		= $this->getResponseDetails($surveyId, $responseId);
		$state		= $this->getState();
		$response	= $return->response;
		$questions	= $return->questions;
		$params		= $state->get('params');
	
		if (count($errors = $this->getErrors()))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
	
		$html		= '<style>.title {font-size: 18pt; font-weight: bold; margin-bottom: 10px; margin-top: 0;}</style>';
		$html 		= $html . SurveyHelper::renderLayout('pdf.results.header', array('item'=>$response, 'params'=>$params));
	
		foreach ($questions as $question)
		{
			$html .= SurveyHelper::renderLayout('pdf.results.question', array('item'=>$question, 'params'=>$params));
		}
	
		// 	echo $html;
		// 	jexit();
	
		// create new PDF document
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/tcpdf.php';
		$pdf = new CJQPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
	
		// set default header data
		$pdf->SetHeaderData('', 0, $response->title, '');
	
		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('corejoomla.com');
		$pdf->SetTitle('Survey Report');
		$pdf->SetSubject('Survey Consolidated Report');
		$pdf->SetKeywords('survey, report');
	
		// set header and footer fonts
		$fontname = $params->get('pdf_fontname', 'helvetica');
		
		$pdf->setHeaderFont(Array($fontname, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array($fontname, '', PDF_FONT_SIZE_DATA));
	
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
	
		//set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
	
		//set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
	
		//set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
	
		// ---------------------------------------------------------
	
		// set font
		$pdf->SetFont($fontname);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->lastPage();
		$pdf->Output($filename, 'F');
	
		return $filename;
	}
	
	public function getLocationsReport($surveyId = null)
	{
		$db = JFactory::getDbo();
		$surveyId = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		
		try 
		{
			$language = JFactory::getLanguage()->getTag();
			
			$query = $db->getQuery(true)
				->select('count(*) as responses, t.country, t.city, c.country_name')
				->from('#__survey_tracking AS t')
				->join('inner', '#__corejoomla_countries AS c on c.country_code = t.country AND c.language IN ('.$db->q('*').','.$db->q($language).') ')
				->join('inner', '#__survey_responses AS r ON t.post_id = r.id AND t.post_type = 1')
				->where('r.survey_id = '.$surveyId)
				->group('t.city, t.country')
				->order('t.country asc, responses desc');

			$db->setQuery($query, 0, 2000);
			$countries = $db->loadAssocList();

			return $countries;
		}
		catch (Exception $e)
		{
			return false;
		}
		
		return false;
	}
	
	public function getBrowsersReport($surveyId = null)
	{
		$db = JFactory::getDbo();
		$surveyId = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		
		try 
		{
			$query = $db->getQuery(true)
				->select('count(*) as count, t.browser_name as browser, t.browser_version as version, t.os as platform')
				->from('#__survey_tracking AS t')
				->join('inner', '#__survey_responses AS r ON t.post_id = r.id AND t.post_type = 1')
				->where('r.survey_id = '.$surveyId)
				->group('t.os, t.browser_version')
				->order('t.browser_name');

			$db->setQuery($query, 0, 2000);
			$countries = $db->loadAssocList();

			return $countries;
		}
		catch (Exception $e)
		{
			return false;
		}
		
		return false;
	}
	
	public function getPlatformsReport($surveyId = null)
	{
		$db = JFactory::getDbo();
		$surveyId = (!empty($surveyId)) ? $surveyId : (int) $this->getState($this->getName() . '.id');
		
		try 
		{
			$query = $db->getQuery(true)
				->select('count(*) as count, t.os as platform')
				->from('#__survey_tracking AS t')
				->join('inner', '#__survey_responses AS r ON t.post_id = r.id AND t.post_type = 1')
				->where('r.survey_id = '.$surveyId)
				->group('t.os')
				->order('t.os');

			$db->setQuery($query, 0, 2000);
			$countries = $db->loadAssocList();

			return $countries;
		}
		catch (Exception $e)
		{
			return false;
		}
		
		return false;
	}
    
    public function getSurveyXmlDownload()
    {
        $surveyId = (int) $this->getState($this->getName() . '.id');
		if(!$surveyId)
		{
			return false;
		}
    }
	
	public function getCsvData()
	{
		$surveyId = (int) $this->getState($this->getName() . '.id');
		if(!$surveyId)
		{
			return false;
		}
		
		$db = JFactory::getDbo();
		$config = array();
		
		$config['filter_fields'] = array(
				'id', 'a.id',
				'survey_id', 'a.survey_id',
				'created', 'a.created',
				'created_by', 'a.created_by',
				'completed', 'a.completed',
				'ip_address', 'a.ip_address',
				'state', 'a.state',
				'ip_address', 't.ip_address',
				'country', 't.country',
				'city', 't.city',
				'browser', 't.browser_name',
				'os', 't.os',
				'author_id',
				'response_status'
		);
		
		$model	= JModelLegacy::getInstance( 'responses', 'CommunitySurveysModel', $config );
		$model->getState(); // access the state first so that it can be modified
		
		$model->setState('survey_id', $surveyId);
		$model->setState('filter.junk', false);
		$model->setState('list.limit', 0);
		$responses = $model->getItems();
		
		if(empty($responses))
		{
			return false;
		}
		
		// get the questions, let us fetch records question by question to avoid shooting up memory.
		$query = $db->getQuery(true)
		  ->select('q.id, q.title, q.question_type')
		  ->from('#__survey_questions AS q')
		  ->join('inner', '#__survey_pages AS p ON p.id = q.page_number')
		  ->where('q.survey_id = '.$surveyId)
		  ->order('p.sort_order asc, q.sort_order asc');
		
		$db->setQuery($query);
		$questions = $db->loadObjectList('id');
		if(empty($questions))
		{
			return false;
		}
		
		$query = $db->getQuery(true)
    		->select('a.id, a.answer_label as title, a.question_id, a.answer_type, a.sort_order, a.image')
    		->from('#__survey_answers AS a')
    		->where('a.question_id IN (select id from #__survey_questions where survey_id = '.$surveyId.')')
    		->order('a.sort_order ASC');
		$db->setQuery($query);
		
		try
		{
		    $answers = $db->loadObjectList();
		}
		catch (Exception $e)
		{
		    // TODO: Something went wrong, with DB
		    return false;
		}
		
		if(!empty($answers))
		{
		    foreach ($questions as $questionId => &$question)
		    {
    		    foreach ($answers as &$answer)
    		    {
    		        if($answer->question_id == $questionId)
		            {
		                if($answer->answer_type == 'y')
		                {
		                    $question->columns[] = $answer;
		                }
		                else
		                {
		                    $question->answers[] = $answer;
		                }
		            }
		        }
		    }
		    
		    unset($question);
		}
		
		// SET TIME LIMIT
		set_time_limit(120);
		
		$csvData = array();
		$headers = array();
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_RESPONSE_ID');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_RESPONSE_STATUS');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_RESPONSE_STATE');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_USER_ID');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_RESPONSE_DATE');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_COMPLETION_DATE');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_IP_ADDRESS');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_USER_NAME');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_LOGIN_NAME');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_EMAIL');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_COUNTRY');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_CITY');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_BROWSER');
		$headers[] = JText::_('COM_COMMUNITYSURVEYS_CSV_HEADER_OS');
		
		$responsesArray = array();
		foreach ($responses as $response)
		{
		    $responseArray = array();
		    $responseArray[] = $response->id;
		    $responseArray[] = $response->completion_status;
		    $responseArray[] = $response->state;
		    $responseArray[] = $response->created_by;
		    $responseArray[] = $response->created;
		    $responseArray[] = $response->completed;
		    $responseArray[] = $response->ip_address;
		    $responseArray[] = $response->name;
		    $responseArray[] = $response->username;
		    $responseArray[] = $response->email;
		    $responseArray[] = $response->country_name;
		    $responseArray[] = $response->city;
		    $responseArray[] = $response->browser_name;
		    $responseArray[] = $response->os;
		    
		    $responsesArray[$response->id] = $responseArray;
		}

		foreach ($questions as $questionId => $question)
		{
    		$query = $db->getQuery(true)
    		  ->select('r.response_id, q.question_type, a.answer_label as answer, b.answer_label as answer2, r.answer_id, r.column_id, r.free_text')
    		  ->from('#__survey_response_details r')
    		  ->join('LEFT', '#__survey_questions AS q ON r.question_id = q.id')
    		  ->join('LEFT', '#__survey_answers AS a ON r.answer_id = a.id')
    		  ->join('LEFT', '#__survey_answers AS b ON r.column_id = b.id')
    		  ->where('r.question_id = '.$questionId);
    		
    		$db->setQuery($query);
    		$details = $db->loadObjectList();
    		
    		if(empty($details))
    		{
    		    continue;
    		}
    		
    		switch ($question->question_type)
    		{
    		    case CS_CHOICE_RADIO: // Choice - Radio
    		    case CS_CHOICE_SELECT: // Choice - Select box
    		    case CS_IMAGE_CHOOSE_IMAGE: // Image - Radio
    		    case CS_CHOICE_SLIDER: // Choice - Slider
    		    case CS_CHOICE_CHECKBOX: // Choice - Checkbox
    		    case CS_IMAGE_CHOOSE_IMAGES: // Image - Checkbox

    		        $headers[] = $question->title;
    		        foreach ($responses as $response)
    		        {
    		            $values = array();
    		            foreach ($details as $detail)
    		            {
    		                if($detail->response_id == $response->id)
    		                {
    		                    if($detail->answer_id > 0)
    		                    {
    		                        $values[] = $detail->answer;
    		                    }
    		                    else if(!empty($detail->free_text)) 
    		                    {
    		                        $values[] = $detail->free_text;
    		                    }
    		                }
    		            }
    		            
    		            $responsesArray[$response->id][] = implode(',', $values);
    		        }
    		        break;

    		    case CS_GRID_RADIO: // Grid - Radio
    		    case CS_GRID_MATCHING: // Matching
    		    case CS_GRID_CHECKBOX: // Grid - Checkbox
    		        
    		        foreach ($question->answers as $gridQuestion)
    		        {
    		            $headers[] = $question->title . ': ' . $gridQuestion->title;
    		            foreach ($responses as $response)
    		            {
    		                $values = array();
    		                foreach ($details as $detail)
    		                {
    		                    if($detail->response_id == $response->id && $detail->answer_id == $gridQuestion->id)
    		                    {
    		                        $values[] = $detail->answer2;
    		                    }
    		                }
    		                
    		                $responsesArray[$response->id][] = implode(',', $values);
    		            }
    		        }
    		        break;

    		    case CS_CHOICE_MULTIRATING: // Multiple rating
    		    case CS_CHOICE_RANKING: // Ranking

    		        foreach ($question->answers as $gridQuestion)
    		        {
    		            $headers[] = $question->title . ': ' . $gridQuestion->title;
    		            foreach ($responses as $response)
    		            {
    		                $value = '';
    		                foreach ($details as $detail)
    		                {
    		                    if($detail->response_id == $response->id && $detail->answer_id == $gridQuestion->id)
    		                    {
    		                        $value = $detail->column_id;
    		                        break; // break, we know only one answer exist per response and grid question
    		                    }
    		                }
    		                
    		                $responsesArray[$response->id][] = $value;
    		            }
    		        }
    		        break;

    		    case CS_CHOICE_NPS: // Choice - Net Promoter Score

    		        $headers[] = $question->title;
    		        foreach ($responses as $response)
    		        {
    		            $values = array();
    		            foreach ($details as $detail)
    		            {
    		                if($detail->response_id == $response->id)
    		                {
    		                    if($detail->answer_id > 0)
    		                    {
    		                        $values[] = $detail->answer_id;
    		                    }
    		                    else if(!empty($detail->free_text))
    		                    {
    		                        $values[] = $detail->free_text;
    		                    }
    		                }
    		            }
    		            
    		            $responsesArray[$response->id][] = implode(',', $values);
    		        }
    		        break;

    		    case CS_FREE_TEXT_SINGLE_LINE: // Freetext - Singleline
    		    case CS_FREE_TEXT_MULTILINE: // Freetext - Multiline
    		    case CS_FREE_TEXT_PASSWORD: // Freetext - Password
    		    case CS_SPECIAL_EMAIL: // Special - Email
    		    case CS_SPECIAL_CALENDAR: // Special - Calendar
    		    case CS_FREE_TEXT_RICH_TEXT: // Freetext - Rich text
    		    case CS_SPECIAL_NAME: // Special - Name
    		    case CS_SPECIAL_ADDRESS: // Special - Address

    		        $headers[] = $question->title;
    		        foreach ($responses as $response)
    		        {
    		            $value = '';
    		            foreach ($details as $detail)
    		            {
    		                if($detail->response_id == $response->id)
    		                {
    		                    $value = $detail->free_text;
    		                    break; // break, we know only one answer exist per response
    		                }
    		            }
    		            
    		            $responsesArray[$response->id][] = $value;
    		        }
    		        break;
    		}
		}
		
		unset($responses);
		unset($details);
		
		$csvData[] = 'sep=,';
		$csvData[] = SurveyHelper::arrayToCsv($headers);

		foreach ($responsesArray as $responseArray)
		{
		    $csvData[] = SurveyHelper::arrayToCsv($responseArray);
		}
		
		return implode(PHP_EOL, $csvData);
	}
    
    public function getTextAnswers($surveyId, $questionId)
    {
        $db = JFactory::getDbo();
        $user = JFactory::getUser();
        $query = $db->getQuery(true)
        	->select('a.response_id, a.question_id, q.question_type, a.answer_id, a.column_id, a.free_text, r.created_by, r.created, u.name as author')
        	->from('#__survey_response_details a')
        	->join('left', '#__survey_responses as r on r.id = a.response_id')
        	->join('left', '#__survey_questions as q on a.question_id = q.id')
        	->join('left', '#__users as u on u.id = r.created_by')
        	->where('r.survey_id = '.$surveyId);
        
        // Filter by published state
        $published = $user->authorise('core.manage', 'com_communitysurveys');
        if (!$published)
        {
        	$query->where('r.state = 1');
        }
        else
        {
        	$query->where('(r.state = 0 OR r.state = 1 OR r.state = 3)');
        }
        
        if(is_array($questionId))
        {
        	$questionId = Joomla\Utilities\ArrayHelper::toInteger($questionId);
        	$query->where('a.question_id in ('.implode(',', $questionId).')');
        }
        else
        {
        	$query->where('a.question_id = '.$questionId);
        }
        
        $query
        	->where('a.free_text is not null and a.free_text <> \'\'')
        	->order('r.created desc');
// echo $query->dump();
        try 
        {
            $db->setQuery($query);
            $answers = $db->loadObjectList();
            
            return $answers;
        }
        catch (Exception $e)
        {
        	echo $e->getMessage();
            return false;
        }
    }
    
    public function getResponseComment($rid)
    {
        $query = $this->_db->getQuery(true)
            ->select('comment')
            ->from('#__survey_responses')
            ->where('id = ' . (int) $rid);
        $this->_db->setQuery($query);
        
        $comment = $this->_db->loadResult();
        
        return $comment;
    }
}