<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JLoader::register('CommunitySurveysHelper', JPATH_ADMINISTRATOR . '/components/com_communitysurveys/helpers/communitysurveys.php');
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/responsebase.php';

class CommunitySurveysModelResponse extends CommunitySurveysModelResponseBase
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	public $typeAlias = 'com_communitysurveys.response';

	public function __construct($config)
	{
	    $config['event_before_save'] 	= 'onResponseBeforeSave';
	    $config['event_after_save'] 	= 'onResponseAfterSave';
	    $config['event_after_delete'] 	= 'onResponseAfterDelete';
	    $config['event_before_delete'] 	= 'onResponseBeforeDelete';
	    $config['event_change_state'] 	= 'onResponseChangeState';
	    $config['events_map'] = array(
	        'delete'       => 'communitysurveys',
	        'save'         => 'communitysurveys',
	        'change_state' => 'communitysurveys'
	    );
	    
		parent::__construct($config);
	}

	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object    $record    A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 */
	protected function canDelete($record)
	{
		if (!empty($record->id))
		{
			if ($record->state != -2)
			{
				return;
			}
			$user = JFactory::getUser();
			return $user->authorise('core.delete');
		}
	}

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param   type      The table type to instantiate
	 * @param   string    A prefix for the table class name. Optional.
	 * @param   array     Configuration array for model. Optional.
	 *
	 * @return  JTable    A database object
	 */
	public function getTable($type = 'Response', $prefix = 'CommunitySurveysTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Custom clean the cache of com_content and content modules
	 */
	protected function cleanCache($group = null, $client_id = 0)
	{
		parent::cleanCache('com_communitysurveys');
	}
	
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_communitysurveys.response', 'response', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}
		return $form;
	}
}