<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JLoader::register('CommunitySurveysHelper', JPATH_ADMINISTRATOR . '/components/com_communitysurveys/helpers/communitysurveys.php');

class CommunitySurveysModelTranslation extends JModelAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	public $typeAlias = 'com_communitysurveys.translation';
	
	public function saveTranslation($id, $translation)
	{
	    $db = $this->getDbo();
	    $user = JFactory::getUser();
	    
	    if(!$user->authorise('core.edit', 'com_communitysurveys'))
	    {
	        $query = $db->getQuery(true)
	        ->select('created_by')
	        ->from('#__survey_translations')
	        ->where('id = ' . $id);
	        $db->setQuery($query);
	        $userId = $db->loadResult();
	        
	        if($userId != $user->id)
	        {
	            throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
	        }
	    }
	    
	    $query = $db->getQuery(true)
	    ->update('#__survey_translations')
	    ->set('translation = ' . $db->q($translation))
	    ->where('id = ' . $id);
	    $db->setQuery($query);
	    $db->execute();
	    
	    return true;
	}

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param   type      The table type to instantiate
	 * @param   string    A prefix for the table class name. Optional.
	 * @param   array     Configuration array for model. Optional.
	 *
	 * @return  JTable    A database object
	 */
	public function getTable($type = 'Translation', $prefix = 'CommunitySurveysTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array      $data        Data for the form.
	 * @param   boolean    $loadData    True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_communitysurveys.translation', 'translation', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$app = JFactory::getApplication();
		$data = $app->getUserState('com_communitysurveys.edit.translation.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}
		
		if(is_array($data) && empty($data['survey_id']))
		{
    		$app = JFactory::getApplication();
    		$data['survey_id'] = $app->input->getInt('survey_id', 0);
		}
		else if(is_object($data) && empty($data->survey_id)) 
		{
		    $app = JFactory::getApplication();
		    $data->survey_id = $app->input->getInt('survey_id', 0);
		}

		$this->preprocessData('com_communitysurveys.translation', $data);
		
		return $data;
	}

	/**
	 * Custom clean the cache of com_communitysurveys and content modules
	 */
	protected function cleanCache($group = null, $client_id = 0)
	{
		parent::cleanCache('com_communitysurveys');
	}
}
