CREATE TABLE IF NOT EXISTS `#__survey_surveys` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) UNSIGNED NOT NULL,
	`catid` INT(10) UNSIGNED NOT NULL,
	`title` VARCHAR(256) NOT NULL,
	`alias` VARCHAR(256) NOT NULL,
	`description` MEDIUMTEXT NULL,
	`endtext` MEDIUMTEXT NULL,
	`custom_header` MEDIUMTEXT NULL,
	`survey_key` VARCHAR(32) NOT NULL,
	`published` TINYINT(3) NOT NULL DEFAULT '1',
	`created_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`private` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
	`restrictions` VARCHAR(32) NOT NULL DEFAULT 'cookie',
	`redirect_url` VARCHAR(999) NULL DEFAULT NULL,
	`max_responses` INT(10) NOT NULL DEFAULT '0',
	`ordering` INT(11) UNSIGNED NOT NULL DEFAULT '0',
	`responses` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`ip_address` VARCHAR(39) NOT NULL DEFAULT '0.0.0.0',
	`access` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`language` CHAR(7) NOT NULL DEFAULT '*',
	`publish_up` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`publish_down` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`checked_out` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`attribs` VARCHAR(5120) NULL DEFAULT NULL,
	`metakey` TEXT NULL,
	`metadesc` TEXT NULL,
	`metadata` TEXT NULL,
	PRIMARY KEY (`id`),
	UNIQUE INDEX `idx_survey_surveys_surveykey` (`survey_key`),
	INDEX `idx_survey_surveys_access` (`access`),
	INDEX `idx_survey_surveys_checkout` (`checked_out`),
	INDEX `idx_survey_surveys_language` (`language`),
	INDEX `idx_survey_surveys_state` (`published`),
	INDEX `idx_survey_surveys_catid` (`catid`),
	INDEX `idx_survey_surveys_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_answers` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `answer_type` varchar(10) DEFAULT NULL,
  `answer_label` mediumtext,
  `sort_order` int(3) unsigned NOT NULL DEFAULT '1',
  `image` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_SURVEY_OPTIONS_SURVEY_ID` (`survey_id`),
  KEY `FK_SURVEY_QUESTIONS_QUESTION_ID` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_contactgroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `contacts` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_contact_group_map` (
  `contact_id` INTEGER UNSIGNED NOT NULL,
  `group_id` INTEGER UNSIGNED NOT NULL,
  PRIMARY KEY (`contact_id`, `group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `email` varchar(128) NOT NULL,
  `created_by` INTEGER UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_uniq_survey_contacts_email` (`email`, `created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_countries` (
  `country_code` varchar(3) NOT NULL,
  `country_name` varchar(64) NOT NULL,
  PRIMARY KEY (`country_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_keys` (
  `key_name` varchar(255) NOT NULL,
  `survey_id` int(10) unsigned NOT NULL,
  `response_id` int(10) unsigned NOT NULL,
  `response_status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_id` int(10) NOT NULL DEFAULT '0',
  KEY `idx_survey_keys_survey_id` (`survey_id`),
  KEY `idx_survey_keys_response_id` (`response_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `sort_order` int(10) unsigned NOT NULL DEFAULT '1',
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_survey_pages_sort_order` (`sort_order`),
  KEY `idx_survey_sid` (`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_question_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(24) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(2048) NOT NULL,
  `description` MEDIUMTEXT DEFAULT NULL,
  `survey_id` int(11) NOT NULL,
  `question_type` int(10) unsigned NOT NULL DEFAULT '0',
  `page_number` int(11) NOT NULL DEFAULT '1',
  `responses` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `custom_choice` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orientation` VARCHAR(2) NOT NULL DEFAULT 'H',
  `min_selections` int(3) UNSIGNED NOT NULL DEFAULT '0',
  `max_selections` int(3) UNSIGNED NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY (`id`),
  KEY `FK_SURVEY_QUESTIONS_SURVEY_ID` (`survey_id`),
  KEY `FK_SURVEY_QUESTIONS_RESPONSE_TYPE` (`question_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_response_details` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `response_id` int(11) NOT NULL DEFAULT '0',
  `question_id` int(11) NOT NULL DEFAULT '0',
  `answer_id` int(11) NOT NULL DEFAULT '0',
  `column_id` int(11) DEFAULT '0',
  `free_text` mediumtext,
  PRIMARY KEY (`id`),
  KEY `FK_SURVEY_RESPONSE_DETAILS_RESPONSE_ID` (`response_id`),
  KEY `FK_SURVEY_RESPONSE_DETAILS_QUESTION_ID` (`question_id`),
  KEY `FK_SURVEY_RESPONSE_DETAILS_OPTION_ID` (`answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_response_types` (
  `id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_responses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `state` TINYINT(3) NOT NULL DEFAULT '1',
  `curr_page` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ip_address` varchar(39) DEFAULT NULL,
  `survey_key` varchar(64) DEFAULT NULL,
  `completed` datetime DEFAULT '0000-00-00 00:00:00',
  `country` varchar(3) DEFAULT NULL,
  `city` VARCHAR(128),
  `browser` varchar(32) DEFAULT NULL,
  `os` varchar(32) DEFAULT NULL,
  `comment` MEDIUMTEXT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_SURVEY_RESPONSES_SURVEY_ID` (`survey_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `survey_id` int(10) unsigned NOT NULL,
  `question_id` int(10) unsigned NOT NULL,
  `rulecontent` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_groups_limit` (
  `survey_id` INTEGER UNSIGNED NOT NULL DEFAULT 0,
  `group_id` INTEGER UNSIGNED NOT NULL DEFAULT 0,
  `max_responses` INTEGER UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`survey_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS  `#__survey_email_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `email_type` varchar(45) NOT NULL,
  `ordering` int(11) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_tracking` (
  `post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `post_type` varchar(6) NOT NULL DEFAULT '0',
  `ip_address` varchar(39) DEFAULT NULL,
  `country` varchar(3) DEFAULT NULL,
  `city` varchar(128) DEFAULT NULL,
  `browser_name` varchar(32) DEFAULT NULL,
  `browser_version` varchar(24) DEFAULT NULL,
  `os` varchar(32) DEFAULT NULL,
  `browser_info` text,
  PRIMARY KEY (`post_id`,`post_type`) USING BTREE,
  KEY `idx_survey_tracking_country` (`country`),
  KEY `idx_survey_tracking_city` (`city`),
  KEY `idx_survey_tracking_browser` (`browser_name`),
  KEY `idx_survey_tracking_os` (`os`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_languages` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`survey_id` INT(11) NOT NULL,
	`language` CHAR(7) NOT NULL,
	`published` TINYINT(3) NOT NULL DEFAULT '1',
	`created_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	PRIMARY KEY (`id`),
	UNIQUE INDEX `uniq_survey_languages_survey_id_language_id` (`survey_id`, `language`),
	INDEX `idx_survey_languages_published` (`published`),
	INDEX `idx_survey_languages_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__survey_translations` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`language_id` INT(10) UNSIGNED NOT NULL COMMENT 'The language code for the item.',
	`item_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`parent_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`item_type` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`translation` MEDIUMTEXT NULL,
	`created_by` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`published` TINYINT(3) NOT NULL DEFAULT '1',
	PRIMARY KEY (`id`),
	UNIQUE INDEX `uniq_survey_translations_item_id_item_type_language` (`item_id`, `item_type`, `language_id`),
	INDEX `idx_survey_translations_published` (`published`),
	INDEX `idx_survey_translations_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__survey_email_templates` (`id`,`title`,`description`,`published`,`email_type`,`ordering`,`created`,`created_by`,`checked_out`,`checked_out_time`,`access`,`language`,`publish_up`,`publish_down`) VALUES 
 (1,'New Survey: {SURVEY_TITLE}','<div style=\"background-color: #e0e0e0; padding: 10px 20px;\">\r\n<div style=\"background-color: #f9f9f9; border-radius: 10px; padding: 5px 10px;\">\r\n<p>Hello {NAME},</p>\r\n<p>{AUTHOR_NAME} submitted a new survey&nbsp;<strong>{SURVEY_TITLE}.</strong></p>\r\n<p><a href=\"{SURVEY_URL}\" class=\"btn-primary\" style=\"font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 2; color: #fff; text-decoration: none; font-weight: bold; text-align: center; cursor: pointer; display: inline-block; border-radius: 25px; background-color: #348eda; margin: 0 10px 0 0; padding: 0; border-color: #348eda; border-style: solid; border-width: 5px 10px;\">&nbsp;&nbsp;View/Take Survey &nbsp;</a></p>\r\n<div>&nbsp;</div>\r\n<div>Have fun interacting with friends and other members on our Community Surveys site.</div>\r\n<div>The {SITENAME} Surveys Team<br /><br /></div>\r\n</div>\r\n<p>You are receiving this automatic email message because you have a subscription <span style=\"color: #666677; font-size: x-small; background-color: #e0e0e0;\">at {SITENAME}.</span></p>\r\n</div>',1,'com_communitysurveys.new_survey',0,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,'*','2015-09-17 06:34:47','0000-00-00 00:00:00'),
 (2,'New Response: {SURVEY_TITLE}','<div style=\"background-color: #e0e0e0; padding: 10px 20px;\">\r\n<div style=\"background-color: #f9f9f9; border-radius: 10px; padding: 5px 10px;\">\r\n<p>Hello {NAME},</p>\r\n<p>{AUTHOR_NAME} responded to your survey&nbsp;<strong>{SURVEY_TITLE}.</strong></p>\r\n<p><a href=\"{SURVEY_URL}\" class=\"btn-primary\" style=\"font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 2; color: #fff; text-decoration: none; font-weight: bold; text-align: center; cursor: pointer; display: inline-block; border-radius: 25px; background-color: #348eda; margin: 0 10px 0 0; padding: 0; border-color: #348eda; border-style: solid; border-width: 5px 10px;\">&nbsp;&nbsp;View Reports &nbsp;</a></p>\r\n<div>&nbsp;</div>\r\n<div>Have fun interacting with friends and other members on our Community Surveys site.</div>\r\n<div>The {SITENAME} Surveys Team<br /><br /></div>\r\n</div>\r\n<p>You are receiving this automatic email message because you have a subscription <span style=\"color: #666677; font-size: x-small; background-color: #e0e0e0;\">at {SITENAME}.</span></p>\r\n</div>',1,'com_communitysurveys.new_response',0,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,'*','2015-09-17 13:46:08','0000-00-00 00:00:00'),
 (3,'You are invited to take a survey', '<div style=\"background-color: #e0e0e0; padding: 10px 20px;\"><div style=\"background-color: #f9f9f9; border-radius: 10px; padding: 5px 10px;\"><p>Hello {NAME},</p><p>You are invited to take a survey. Please click on the below link to respond to the survey.</p><p><a href=\"{SURVEY_URL}\" class=\"btn-primary\" style=\"font-family: \'Helvetica Neue\', \'Helvetica\', Helvetica, Arial, sans-serif; font-size: 100%; line-height: 2; color: #fff; text-decoration: none; font-weight: bold; text-align: center; cursor: pointer; display: inline-block; border-radius: 25px; background-color: #348eda; margin: 0 10px 0 0; padding: 0; border-color: #348eda; border-style: solid; border-width: 5px 10px;\">&nbsp;&nbsp;Take Survey &nbsp;</a></p><div>If the above button do not work, copy paste the below url into your browser url bar:</div><div>{SURVEY_URL}</div><div>&nbsp;</div><div>Have fun interacting with friends and other members on our Community Surveys site.</div><div>The {SITENAME} Surveys Team<br /><br /></div></div><p>You are receiving this email message because you are registered user on the website.</p></div>',1,'com_communitysurveys.invitation',0,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,'*','2015-09-17 13:46:08','0000-00-00 00:00:00'),
 (4,'Thank you for taking survey', '<div style=\"background-color: #e0e0e0; padding: 10px 20px;\"><div style=\"background-color: #f9f9f9; border-radius: 10px; padding: 5px 10px;\"><p>Hello {NAME},</p><p>Thank you for taking our survey {SURVEY_TITLE}. Your answers are registered successfully.</p><div>Have fun interacting with friends and other members on our Community Surveys site.</div><div>The {SITENAME} Surveys Team<br /><br /></div></div><p>You are receiving this email message because you are registered user on the website.</p></div>',1,'com_communitysurveys.thankyou',0,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,'*','2017-06-10 13:46:08','0000-00-00 00:00:00')
 ON DUPLICATE KEY UPDATE created = VALUES (created);