<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die();

class CommunitySurveysTableResponse extends JTable
{
	public function __construct (JDatabaseDriver $db)
	{
		parent::setColumnAlias('published', 'state');
		parent::__construct('#__survey_responses', 'id', $db);
	}

	protected function _getAssetName ()
	{
		$k = $this->_tbl_key;
		return 'com_communitysurveys.response.' . (int) $this->$k;
	}

	protected function _getAssetTitle ()
	{
		return $this->title;
	}

	protected function _getAssetParentId (JTable $table = null, $id = null)
	{
		$assetId = null;
		
		// This is a question under a category.
		if ($this->catid)
		{
			// Build the query to get the asset id for the parent category.
			$query = $this->_db->getQuery(true)
				->select($this->_db->quoteName('asset_id'))
				->from($this->_db->quoteName('#__survey_surveys'))
				->where($this->_db->quoteName('id') . ' = ' . (int) $this->survey_id);
			
			// Get the asset id from the database.
			$this->_db->setQuery($query);
			
			if ($result = $this->_db->loadResult())
			{
				$assetId = (int) $result;
			}
		}
		
		// Return the asset id.
		if ($assetId)
		{
			return $assetId;
		}
		else
		{
			return parent::_getAssetParentId($table, $id);
		}
	}
	
	public function open($pks = null, $state = 1, $userId = 0)
	{
		// Sanitize input
		$userId = (int) $userId;
		$state  = (int) $state;
	
		if (!is_null($pks))
		{
			if (!is_array($pks))
			{
				$pks = array($pks);
			}
	
			foreach ($pks as $key => $pk)
			{
				if (!is_array($pk))
				{
					$pks[$key] = array($this->_tbl_key => $pk);
				}
			}
		}
	
		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			$pk = array();
	
			foreach ($this->_tbl_keys as $key)
			{
				if ($this->$key)
				{
					$pk[$key] = $this->$key;
				}
				// We don't have a full primary key - return false
				else
				{
					$this->setError(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
	
					return false;
				}
			}
	
			$pks = array($pk);
		}
	
		$publishedField = $this->getColumnAlias('completed');
		$checkedOutField = $this->getColumnAlias('checked_out');
	
		foreach ($pks as $pk)
		{
			// Update the publishing state for rows with the given primary keys.
			$query = $this->_db->getQuery(true)
				->update($this->_tbl)
				->set($this->_db->quoteName($publishedField) . ' = ' . (int) $state);
	
			// Determine if there is checkin support for the table.
			if (property_exists($this, 'checked_out') || property_exists($this, 'checked_out_time'))
			{
				$query->where('(' . $this->_db->quoteName($checkedOutField) . ' = 0 OR ' . $this->_db->quoteName($checkedOutField) . ' = ' . (int) $userId . ')');
				$checkin = true;
			}
			else
			{
				$checkin = false;
			}
	
			// Build the WHERE clause for the primary keys.
			$this->appendPrimaryKeys($query, $pk);
	
			$this->_db->setQuery($query);
	
			try
			{
				$this->_db->execute();
			}
			catch (Exception $e)
			{
				$this->setError($e->getMessage());
	
				return false;
			}
	
			// If checkin is supported and all rows were adjusted, check them in.
			if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
			{
				$this->checkin($pk);
			}
	
			// If the JTable instance value is in the list of primary keys that were set, set the instance.
			$ours = true;
	
			foreach ($this->_tbl_keys as $key)
			{
				if ($this->$key != $pk[$key])
				{
					$ours = false;
				}
			}
	
			if ($ours)
			{
				$this->$publishedField = $state;
			}
		}
	
		$this->setError('');
	
		return true;
	}
}
