<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die();


$user = JFactory::getUser();
$wysiwyg = true;
$bbcode = $wysiwyg && ($this->params->get('default_editor', 'bbcode') == 'bbcode');
$content = $this->params->get('process_content_plugins', 0) == 1;

require_once JPATH_ROOT.DS.'components'.DS.Q_APP_NAME.DS.'helpers'.DS.'formfields.php';
$formfields = new SurveyFormFields($wysiwyg, $bbcode, $content);
?>

<div id="cj-wrapper">
	
	<h2 class="page-header"><?php echo $this->escape($this->survey->title);?></h2>
	
	<form id="adminForm" name="adminForm" action="<?php echo JRoute::_('index.php?option='.Q_APP_NAME.'&view=approval')?>" method="post">
		<?php 
		$class = '';
		foreach ($this->survey->questions as $qid=>$question){
			
			$question->responses = array();
			
			switch($question->question_type){
				case CS_PAGE_HEADER:
					echo $formfields->get_page_header_question($question, $class);
					break;
				case CS_CHOICE_RADIO:
					echo $formfields->get_radio_question($question, $class);
					break;
				case CS_CHOICE_CHECKBOX:
					echo $formfields->get_checkbox_question($question, $class);
					break;
				case CS_CHOICE_SELECT:
					echo $formfields->get_select_question($question, $class);
					break;
				case CS_GRID_RADIO:
					echo $formfields->get_grid_radio_question($question, $class);
					break;
				case CS_GRID_CHECKBOX:
					echo $formfields->get_grid_checkbox_question($question, $class);
					break;
				case CS_FREE_TEXT_SINGLE_LINE:
					echo $formfields->get_single_line_textbox_question($question, $class);
					break;
				case CS_FREE_TEXT_MULTILINE:
					echo $formfields->get_multiline_textarea_question($question, $class);
					break;
				case CS_FREE_TEXT_PASSWORD:
					echo $formfields->get_password_textbox_question($question, $class);
					break;
				case CS_FREE_TEXT_RICH_TEXT:
					echo $formfields->get_rich_textbox_question($question, $class);
					break;
				case CS_IMAGE_CHOOSE_IMAGE:
					echo $formfields->get_image_radio_question($question, $class, CS_IMAGES_URI);
					break;
				case CS_IMAGE_CHOOSE_IMAGES:
					echo $formfields->get_image_checkbox_question($question, $class, CS_IMAGES_URI);
					break;
				default: break;
			}
		}
		?>
		
		<input type="hidden" name="cid[]" value="<?php echo $this->survey->id;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="1" />
	</form>
</div>