<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysViewDashboard extends JViewLegacy
{
	protected $state;
	
	public function display ($tpl = null)
	{
		$model = $this->getModel();
		$state = $model->getState();
		
		$model->setState('list.ordering', 'a.created');
		$model->setState('list.direction', 'desc');
		$this->recent = $model->getItems();
		
		$model->setState('list.ordering', 'a.responses');
		$this->trending = $model->getItems();
		
		JLoader::import('joomla.application.component.model');
		JLoader::import('users', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
		$model = JModelLegacy::getInstance( 'users', 'CommunitySurveysModel' );
		
		CommunitySurveysHelper::addSubmenu('dashboard');
		$this->addToolbar();
		
		if(CS_MAJOR_VERSION == 3)
		{
		    $this->sidebar = JHtmlSidebar::render();
		}
		
		$version = CJFunctions::get_component_update_check('com_communitysurveys', CS_CURR_VERSION);
		$this->version = $version;
		
		parent::display($tpl);
	}

	protected function addToolbar ()
	{
		$canDo = JHelperContent::getActions('com_communitysurveys');
		$user = JFactory::getUser();
		
		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');
		
		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_DASHBOARD_TITLE'), 'stack dashboard');
		
		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
			JToolbarHelper::preferences('com_communitysurveys');
		}
	}
}
