<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysViewLanguage extends JViewLegacy
{
	protected $form;

	protected $item;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->survey   = $this->get('Survey');
		$this->state	= $this->get('State');

		// Check for errors.
		if (!empty($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
		
		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$isNew = empty($this->item->id) ? true : false;
		$pageTitle = JText::_('COM_COMMUNITYSURVEYS_PAGE_' . ($isNew ? 'ADD_LANGUAGE' : 'EDIT_LANGUAGE'));
		JToolbarHelper::title($pageTitle . ' (' . CjLibUtils::escape($this->survey->title) . ')', 'pencil-2 item-add');

		JToolbarHelper::save('language.save');
		JToolbarHelper::cancel('language.cancel');
	}
}
