<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$archived	= $this->state->get('filter.published') == 2 ? true : false;
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
$sortFields = $this->getSortFields();
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
			<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=languages&survey_id='.$this->survey_id); ?>" method="post" name="adminForm" id="adminForm">
        		<?php
        		// Search tools bar
        		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
        		?>
        		<?php if (empty($this->items)) : ?>
        			<div class="alert alert-no-items">
        				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
        			</div>
        		<?php else : ?>
        			<table class="table table-striped" id="languageList">
        				<thead>
        					<tr>
        						<th width="1%" class="hidden-phone hidden-xs">
        							<?php echo JHtml::_('grid.checkall'); ?>
        						</th>
        						<th width="1%" style="min-width:55px" class="nowrap text-center">
        							<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JText::_('COM_COMMUNITYSURVEYS_TRANSLATE');?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort',  'JAUTHOR', 'a.created_by', $listDirn, $listOrder); ?>
        						</th>
        						<th class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JDATE', 'a.created', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_HEADING_SURVEY_ID', 'a.survey_id', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
        						</th>
        					</tr>
        				</thead>
        				<tbody>
        				<?php foreach ($this->items as $i => $item) :
        					$item->max_ordering = 0; //??
        					$canEdit    = $user->authorise('core.edit',       'com_communitysurveys');
        					$canEditOwn = $user->authorise('core.edit.own',   'com_communitysurveys') && $item->created_by == $userId;
        					$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys');
        					?>
        					<tr class="row<?php echo $i % 2; ?>">
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
        						</td>
        						<td class="text-center">
        							<div class="btn-group">
        								<?php echo JHtml::_('jgrid.published', $item->published, $i, 'languages.', $canChange, 'cb', '0000-00-00 00:00:00', '0000-00-00 00:00:00'); ?>
        								<?php
        								// Create dropdown items
        								$action = $archived ? 'unarchive' : 'archive';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'languages');
        
        								$action = $trashed ? 'untrash' : 'trash';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'languages');
        
        								// Render dropdown list
        								echo JHtml::_('actionsdropdown.render', $this->escape($item->language));
        								?>
        							</div>
        						</td>
        						<td class="has-context">
        							<div class="pull-left">
        								<?php if ($canEdit || $canEditOwn) : ?>
        									<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=language.edit&id=' . $item->id.'&survey_id='.$item->survey_id); ?>" title="<?php echo JText::_('JACTION_EDIT'); ?>">
        										<?php echo $this->escape($item->language); ?></a>
        								<?php else : ?>
        									<span><?php echo $this->escape($item->language); ?></span>
        								<?php endif; ?>
        							</div>
        						</td>
        						<td>
        							<a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=translations&survey_id=' . $item->survey_id.'&language='.$item->id);?>">
        								<i class="fa fa-globe"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_TRANSLATE');?>
        							</a>
        						</td>
        						<td class="small hidden-phone hidden-xs">
        							<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
        								<?php echo $this->escape($item->author_name); ?>
        							</a>
        						</td>
        						<td class="nowrap small hidden-phone hidden-xs">
        							<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC4')); ?>
        						</td>
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo (int) $item->survey_id; ?>
        						</td>
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo (int) $item->id; ?>
        						</td>
        					</tr>
        					<?php endforeach; ?>
        				</tbody>
        			</table>
        		<?php endif; ?>
        		<?php echo $this->pagination->getListFooter(); ?>
        
        		<input type="hidden" name="survey_id" value="<?php echo $this->survey_id;?>" />
        		<input type="hidden" name="task" value="" />
        		<input type="hidden" name="boxchecked" value="0" />
        		<?php echo JHtml::_('form.token'); ?>
			</form>
		</div>
	</div>
</div>
