<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$span = !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
?>
<script type="text/javascript">
	var incrementSurveys = 10;
	var incrementTags = 50;
	MigrateV4 = function() 
	{ 
		jQuery('#sync-progress').show();
		doMigration(0, 0, 0);
	}

	function doMigration(startId, endId, lastId)
	{
		try
		{
			startId = parseInt(startId);
			endId = parseInt(endId);
			lastId = parseInt(lastId);
		}
		catch(e){}
		
		jQuery.ajax({
			url: '<?php echo JRoute::_('index.php?option=com_communitysurveys&task=migrate.execute&format=json', false);?>',
			dataType: 'json',
			data: {
				'items': 'surveys',
				'startId': startId,
				'endId': endId,
				'lastId': lastId
			},
			beforeSend: function( xhr ) {
				jQuery('#sync-progress').show();
			}
		}).done(function(r){
			if(r.success)
			{
				if(r.data == -1)
				{
					doMigration(endId + 1, endId + incrementSurveys, lastId);
				}
				else
				{
					doMigration(0, incrementSurveys, r.data.max_id);
				}
			}
			else
			{
				if(endId < lastId)
				{
					// there is something wrong or data not found. continue with next
					doMigration(endId + 1, endId + incrementSurveys, lastId);
				}
				else
				{
					jQuery('#msg_surveys_status').html(r.message);
					jQuery('#sync-tags-progress').show();
					doTagsMigration(0, 0, 0);
				}
			}
			
			percent = lastId > 0 ? Math.round((endId - incrementSurveys) * 100 / lastId) : 0;
			jQuery('#sync-progress').find('.bar').attr('style', 'width: '+percent+'%').find('.pct').text((percent > 100 ? 100 : percent)+'%');
		})
		.fail(function(data){
			alert(data.message);
		});
	}

	function doTagsMigration(startId, endId, lastId)
	{
		try
		{
			startId = parseInt(startId);
			endId = parseInt(endId);
			lastId = parseInt(lastId);
		}
		catch(e){}
		
		jQuery.ajax({
			url: '<?php echo JRoute::_('index.php?option=com_communitysurveys&task=migrate.execute&format=json', false);?>',
			dataType: 'json',
			data: {
				'items': 'tags',
				'convert_bbcode': (jQuery('input[name="convert_bbcode"]').is(':checked') ? 1 : 0),
				'startId': startId,
				'endId': endId,
				'lastId': lastId
			},
			beforeSend: function( xhr ) {
				jQuery('#sync-tags-progress').show();
			}
		}).done(function(r){
			if(r.success)
			{
				if(r.data == -1)
				{
					doTagsMigration(endId + 1, endId + incrementTags, lastId);
				}
				else
				{
					doTagsMigration(0, incrementTags, r.data.max_id);
				}
			}
			else
			{
				if(endId < lastId)
				{
					// there is something wrong or data not found. continue with next
					doTagsMigration(endId + 1, endId + incrementTags, lastId);
				}
				else
				{
					jQuery('#msg_tags_status').html(r.message);
				}
			}
			
			percent = lastId > 0 ? Math.round((endId - incrementTags) * 100 / lastId) : 0;
			jQuery('#sync-tags-progress').find('.bar').attr('style', 'width: '+percent+'%').find('.pct').text((percent > 100 ? 100 : percent)+'%');
		})
		.fail(function(data){
			alert(data.message);
		});
	}
</script>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
        	<div class="well well-small">
        		<p>Please use this migration form if you were using Community Surveys v3 and now upgrading to v4.</p>
        		<?php if(JFactory::getUser()->authorise('core.admin', 'com_communitysurveys')):?>
        		<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> This process will alter your table (XXX_survey* & XXX_assets) data. Please do not proceed without taking backup of your database tables.</div>
        		<label class="checkbox"><input type="checkbox" name="convert_bbcode"> Convert BBCode to Html</label>
        		<br/>
        		<button class="btn btn-primary" id="btn-migrate" onclick="JavaScript: MigrateV4();" style="margin-bottom: 10px;">
        			<?php echo "Start Migration"?>
        		</button>
        		<div id="sync-progress" style="display: none;">
        			<p>Migrating surveys now. <span id="msg_surveys_status"></span></p>
        			<div class="progress progress-striped">
        				<div class="bar" style="width: 0%;"><span class="pct"></span></div>
        			</div>
        		</div>
        		<div id="sync-tags-progress" style="display: none;">
        			<p>Migrating tags now. <span id="msg_tags_status"></span></p>
        			<div class="progress progress-striped">
        				<div class="bar" style="width: 0%;"><span class="pct"></span></div>
        			</div>
        		</div>
        		<?php else:?>
        		<p>You do not have access to this feature.</p>
        		<?php endif;?>
        	</div>
        </div>
	</div>
</div>
