<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysViewMigrate extends JViewLegacy 
{
	function display($tpl = null) 
	{
		JToolBarHelper::title(JText::_('COM_COMMUNITYSURVEYS_MENU_MIGRATION'), 'logo.png');
		$model = $this->getModel('migrate');
		
		$app = JFactory::getApplication();
		$user= JFactory::getUser();
		$layout = $app->input->getCmd('layout', null);
		
		if($layout)
		{
			$this->setLayout($layout);
		}
		
		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			CommunitySurveysHelper::addSubmenu('migrate');
			
			if(CS_MAJOR_VERSION == 3)
			{
			    $this->sidebar = JHtmlSidebar::render();
			}
		}
		
		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_MENU_MIGRATION'), 'stack dashboard');
		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
		    JToolbarHelper::preferences('com_communitysurveys');
		}
		
		parent::display($tpl);
	}
}
?>