<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

JFactory::getDocument()->addScript('https://www.google.com/jsapi');

$params  	= $this->params;
$layout 	= CS_MAJOR_VERSION < 4 ? 'default' : 'bootstrap4';
$params->set('ui_layout', $layout);

$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
$return     = base64_encode(JUri::getInstance());
$uri 		= 'index.php?option=com_communitysurveys&view=reports';
?>
<div class="cj-wrapper" id="cj-wrapper">
	<?php if ($this->print <= 0 && !empty( $this->sidebar)) : ?>
	<div class="row-fluid">
    	<div id="j-sidebar-container" class="span2">
    		<?php echo $this->sidebar; ?>
    	</div>
    	<div class="span10">
	<?php endif;?>
            <div class="<?php echo $this->print > 0 ? 'print' : $span;?>">
            	<div id="j-main-container">
                	<form action="<?php echo JRoute::_('index.php'); ?>" method="post" name="adminForm" id="adminForm">
            			<?php if(!$this->print):?>
            			<div class="report-navigation clearfix margin-bottom-20">
            				<div class="btn-group pull-right">
            					<button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
            						<i class="fa fa-bar-chart"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_CHOOSE_DIFFERENT_REPORT');?> <span class="caret"></span>
            					</button>
            					<ul class="dropdown-menu" role="menu">
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=dashboard&id='.$this->item->id)?>">
            								<i class="fa fa-home"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_DASHBOARD');?>
            							</a>
            						</li>
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=responses&id='.$this->item->id)?>">
            								<i class="fa fa-comments"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?>
            							</a>
            						</li>
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=consolidated&id='.$this->item->id)?>">
            								<i class="fa fa-suitcase"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONSOLIDATED');?>
            							</a>
            						</li>
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=locations&id='.$this->item->id)?>">
            								<i class="fa fa-globe"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_LOCATIONS');?>
            							</a>
            						</li>
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=browsers&id='.$this->item->id)?>">
            								<i class="fa fa-internet-explorer"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_BROWSERS');?>
            							</a>
            						</li>
            						<li class="dropdown-item">
            							<a href="<?php echo JRoute::_($uri.'&layout=platforms&id='.$this->item->id)?>">
            								<i class="fa fa-windows"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_PLATFORMS');?>
            							</a>
            						</li>
            					</ul>
            				</div>
            				<div class="report-actions">
            					<?php if(($this->layout == 'response' || $this->layout == 'consolidated') && !$this->print):?>
            				    <button type="button" class="btn btn-default btn-print-pdf" data-url="<?php echo JRoute::_(JUri::getInstance().'&print=true')?>">
            				        <i class="fa fa-file-pdf-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PRINT_DOWNLOAD_PDF');?>
                                </button>
            					<?php endif;?>
            					
            					<?php if($this->layout == 'responses'):?>
            				    <a class="btn btn-primary" href="<?php echo JRoute::_($uri.'&id='.$this->item->id.'&task=responses.downloadCsvReport')?>" target="_blank">
            				        <i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_DOWNLOAD_CSV');?>
                                </a>
            					<?php endif;?>
            				</div>
            			</div>
            			<?php endif;?>
            			
            			<h4 class="page-header" style="margin-top: 10px; padding-top: 0;"><?php echo $this->escape($this->item->title);?></h4>
            			<?php echo SurveyHelper::renderLayout($layout.'.reports.'.$this->layout, array('data'=>$this), CS_LAYOUTS_BASE_PATH, array('debug' => false));?>
                		
                		<input type="hidden" name="task" id="task" value="" />
                		<input type="hidden" name="option" id="option" value="com_communitysurveys" />
                		<input type="hidden" name="view" id="view" value="reports" />
                		<input type="hidden" name="id" value="<?php echo $this->item->id;?>" />
                		<input type="hidden" name="boxchecked" value="0" />
                		<input type="hidden" name="return" value="<?php echo $return;?>" />
                		<input type="hidden" id="cjpageid" value="reports">
                		<?php echo JHtml::_('form.token'); ?>
                	</form>
                
                	<form name="surveyForm" id="surveyForm" action="<?php echo JRoute::_('index.php?option=com_communitysurveys')?>" method="post">
                	   <input type="hidden" name="task" value="reports.getanswers" />
                	   <input type="hidden" name="qid" value="" />
                	   <input type="hidden" name="id" value="<?php echo $this->item->id;?>" />
                	</form>
                	
                	<form id="commentform" action="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=reports.comment&id='.$this->item->id.'&format=json');?>" style="display: none;">
                		<textarea name="comment" rows="3" cols="40" class="input-block-level"></textarea>
                		<input type="hidden" name="rid" value="0">
                		<input type="hidden" name="commentId" value="0">
                		
                		<div class="alert alert-info messages"></div>
                		<div class="comment-actions">
                			<button type="button" class="btn btn-default btn-mini btn-comment-cancel"><?php echo JText::_('JCANCEL');?></button>
                			<button type="button" class="btn btn-primary btn-mini btn-comment-submit"><?php echo JText::_('JSUBMIT');?></button>
                		</div>
                	</form>
                </div>
        	</div>
	<?php if (!empty( $this->sidebar)) : ?>
    	</div>
    </div>
	<?php endif;?>
</div>

<?php if($this->print):?>
<script type="text/javascript">window.print();</script>
<?php endif;?>
<iframe id="rptiFrame" style="width: 0; height: 0; display: none;"></iframe>
