<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewReports extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	public function display($tpl = null)
	{
		$user           = JFactory::getUser();
		$app			= JFactory::getApplication();
		$this->item		= $this->get('Item');
		
		if($this->item->created_by != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id))
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$content = $this->get('CsvData');
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
		
		$document = JFactory::getDocument();
		$document->setCharset('UTF-8');
		$document->setMimeEncoding('application/vnd.ms-excel');
		$app->setHeader('Content-disposition', 'attachment; filename="responses.csv"; creation-date="' . JFactory::getDate()->toRFC822() . '"', true);

		echo chr(255) . chr(254) . mb_convert_encoding($content, 'UTF-16LE', 'UTF-8');
	}
}
