<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewResponses extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	public function display($tpl = null)
	{
		if ($this->getLayout() !== 'modal')
		{
			CommunitySurveysHelper::addSubmenu('responses');
		}

		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		$this->authors       = $this->get('Authors');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			$this->addToolbar();
			
			if(CS_MAJOR_VERSION == 3)
			{
			    $this->sidebar = JHtmlSidebar::render();
			}
		}

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		$canDo = JHelperContent::getActions('com_communitysurveys', 'category', $this->state->get('filter.category_id'));
		$user  = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolBar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_COMMUNITYSURVEYS_SURVEYS_TITLE'), 'stack survey');

		if ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::publish('responses.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('responses.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			JToolbarHelper::archiveList('responses.archive');
		}
		
		if ($this->state->get('filter.published') == -2 && $canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('', 'responses.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
		elseif ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::trash('responses.trash');
		}

		if ($user->authorise('core.admin', 'com_communitysurveys'))
		{
			JToolbarHelper::preferences('com_communitysurveys');
		}
	}

	protected function getSortFields()
	{
		return array(
			'a.state'			=> JText::_('JSTATUS'),
			'a.created_by'		=> JText::_('JAUTHOR'),
			'a.created'			=> JText::_('JDATE'),
			't.ip_address'		=> JText::_('COM_COMMUNITYSURVEYS_IP_ADDRESS'),
			't.country'			=> JText::_('COM_COMMUNITYSURVEYS_COUNTRY'),
			't.city'			=> JText::_('COM_COMMUNITYSURVEYS_CITY'),
			't.browser_name'	=> JText::_('COM_COMMUNITYSURVEYS_BROWSER'),
			't.os'				=> JText::_('COM_COMMUNITYSURVEYS_OS')
		);
	}
}
