<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JHTML::_('behavior.formvalidator');
JHTML::_('behavior.keepalive');
JHTML::_('behavior.calendar');
JHTML::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

jimport('joomla.html.editor');

$params 	= $this->state->get('params');
$layout 	= CS_MAJOR_VERSION < 4 ? 'default' : 'bootstrap4';
$params->set('ui_layout', $layout);

if(CS_MAJOR_VERSION < 4)
{
    JHtml::_('jquery.ui', array('core', 'sortable'));
} 
else 
{
    CjScript::_('sortable');
}
?>
<style>
<!--
#cj-wrapper .question-tabs .nav.nav-tabs {justify-content: end;}
#cj-wrapper .question-tabs .nav.nav-tabs .nav-item {width: auto !important;}
#cj-wrapper .question-tabs .nav.nav-tabs .nav-item:last-child {width: 100% !important; text-align: right;}
-->
</style>
<div id="cj-wrapper">
	<div id="survey-main-wrapper" class="survey-main-wrapper <?php echo CS_MAJOR_VERSION < 4 ? 'row-fluid' : 'row';?>">
		<div class="<?php echo CS_MAJOR_VERSION < 4 ? 'span2' : 'col-md-2';?>">
			<div class="panel-group" id="question-types" role="tablist" aria-multiselectable="true">
				<div class="panel panel-<?php echo $layout;?>">
					<div class="panel-heading" role="tab">
						<h4 class="panel-title">
							<a data-toggle="collapse" data-parent="#question-types" href="#choice-questions" aria-expanded="true" aria-controls="choice-questions">
								<?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_CHOICE');?>
							</a>
						</h4>
					</div>
					<div id="choice-questions" class="panel-collapse collapse in">
						<div class="list-group">
							<a href="#" id="qntype-radio" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_RADIO;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-dot-circle-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_RADIO');?>
							</a>
							<a href="#" id="qntype-checkbox" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_CHECKBOX;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-check-square-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_CHECKBOX');?>
							</a>
							<a href="#" id="qntype-select" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_SELECT;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-hand-o-up"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_SELECT');?>
							</a>
							<a href="#" id="qntype-select" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_MULTIRATING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-star"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_MULTIRATING');?>
							</a>
							<a href="#" id="qntype-select" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_RANKING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-sort-numeric-asc"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOICE_RANKING');?>
							</a>
							<a href="#" id="qntype-select" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_SLIDER;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-sliders"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_SLIDER');?>
							</a>
							<a href="#" id="qntype-select" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_CHOICE_NPS;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-tachometer"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_NPS');?>
							</a>
						</div>
					</div>
				</div>
				<div class="panel panel-<?php echo $layout;?>" role="tablist" aria-multiselectable="true">
					<div class="panel-heading" role="tab">
						<h4 class="panel-title">
							<a data-toggle="collapse" data-parent="#question-types" href="#grid-questions" aria-expanded="true" aria-controls="grid-questions">
								<?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_GRID');?>
							</a>
						</h4>
					</div>
					<div id="grid-questions" class="panel-collapse collapse">
						<div class="list-group">
							<a href="#" id="qntype-grid-radio" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_GRID_RADIO;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-th-large"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_RADIO');?>
							</a>
							<a href="#" id="qntype-grid-radio" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_GRID_CHECKBOX;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-th"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_CHECKBOX');?>
							</a>
							<a href="#" id="qntype-matching" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_GRID_MATCHING;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-list-ol"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_GRID_MATCHING');?>
							</a>
						</div>
					</div>
				</div>
				<div class="panel panel-<?php echo $layout;?>" role="tablist" aria-multiselectable="true">
					<div class="panel-heading" role="tab">
						<h4 class="panel-title">
							<a data-toggle="collapse" data-parent="#question-types" href="#freetext-questions" aria-expanded="true" aria-controls="freetext-questions">
								<?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_FREETEXT');?>
							</a>
						</h4>
					</div>
					<div id="freetext-questions" class="panel-collapse collapse">
						<div class="list-group">
							<a href="#" id="qntype-singleline" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_SINGLE_LINE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-minus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_SINGLE_LINE');?>
							</a>
							<a href="#" id="qntype-multiline" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_MULTILINE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-align-justify"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_MULTI_LINE');?>
							</a>
							<a href="#" id="qntype-password" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_PASSWORD;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-qrcode"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_PASSWORD');?>
							</a>
							<a href="#" id="qntype-richtext" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_FREE_TEXT_RICH_TEXT;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-file"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FREETEXT_RICHTEXT');?>
							</a>
						</div>
					</div>
				</div>
				<div class="panel panel-<?php echo $layout;?>" role="tablist" aria-multiselectable="true">
					<div class="panel-heading" role="tab">
						<h4 class="panel-title">
							<a data-toggle="collapse" data-parent="#question-types" href="#image-questions" aria-expanded="true" aria-controls="image-questions">
								<?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_IMAGE');?>
							</a>
						</h4>
					</div>
					<div id="image-questions" class="panel-collapse collapse">
						<div class="list-group">
							<a href="#" id="qntype-image" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_IMAGE_CHOOSE_IMAGE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-picture-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOOSE_IMAGE');?>
							</a>
							<a href="#" id="qntype-images" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_IMAGE_CHOOSE_IMAGES;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-film"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CHOOSE_IMAGES');?>
							</a>
						</div>
					</div>
				</div>
				<div class="panel panel-<?php echo $layout;?>" role="tablist" aria-multiselectable="true">
					<div class="panel-heading" role="tab">
						<h4 class="panel-title">
							<a data-toggle="collapse" data-parent="#question-types" href="#special-questions" aria-expanded="true" aria-controls="special-questions">
								<?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_GROUP_SPECIAL');?>
							</a>
						</h4>
					</div>
					<div id="special-questions" class="panel-collapse collapse">
						<div class="list-group">
							<a href="#" id="qntype-header" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_PAGE_HEADER;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-magnet"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_PAGE_HEADER');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_FILE_UPLOAD;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-upload"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_FILE_UPLOAD');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_NAME;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-user"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_NAME');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_SIGNATURE;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-pencil-square-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_SIGNATURE');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_EMAIL;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_EMAIL');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_CALENDAR;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-calendar"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_CALENDAR');?>
							</a>
							<a href="#" id="qntype-fileupload" class="list-group-item"
								onclick="document.questionForm.qtype.value=<?php echo CS_SPECIAL_ADDRESS;?>;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.add', 'onBeforeAddQuestion', 'onAfterAddQuestion'); return false;">
								<i class="fa fa-home"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_TYPE_ADDRESS');?>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="<?php echo CS_MAJOR_VERSION < 4 ? 'span10' : 'col-md-10';?>">
			<div class="alert alert-info margin-top-10">
				<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_FORM_HELP');?>
			</div>
			
			<div class="well well-small margin-top-10 mb-2 clearfix">
                <div class="pull-right">
                
                	<a href="#PreviewQuestionsModal" data-toggle="modal" class="btn btn-default">
                        <i class="fa fa-eye"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PREVIEW_QUESTIONS');?>
                    </a>
                    <?php 
                    echo JHtml::_(
                    		'bootstrap.renderModal',
                    		'PreviewQuestionsModal',
                    		array(
                    				'title'       => JText::_('COM_COMMUNITYSURVEYS_PREVIEW_QUESTIONS'),
                    				'backdrop'    => 'static',
                    				'keyboard'    => true,
                    				'closeButton' => true,
                    				'url'         => JRoute::_('index.php?option=com_communitysurveys&view=survey&layout=preview&id='.$this->item->id),
                    				'height'      => '400px',
                    				'width'       => '800px',
                    				'bodyHeight'  => '70',
                    				'modalWidth'  => '80',
                    				'footer'      => '',
                    		)
                    	);
                    ?>
                    <a href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=survey.publish&id='.$this->item->id);?>" class="btn btn-primary">
                        <i class="fa fa-check"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PUBLISH_SURVEY');?>
                    </a>
                </div>
				<select id="pageid" name="pageid" size="1">
					<?php 
					if(!empty($this->pages))
					{
						foreach ($this->pages as $page)
						{
							?>
							<option value="<?php echo $page->id;?>"<?php $this->pid == $page->id ? ' selected="selected"' : '';?>>
								<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $page->title, array('jsSafe'=>true)).' (ID: '.$page->id.')';?>
							</option>
							<?php
						}
					}
					?>
				</select>
				
				<div class="btn-group">
					<button type="button" class="btn btn-default btn-small btn-sm btn-edit-page-title" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_EDIT_PAGE_TITLE');?>">
						<i class="fa fa-pencil"></i>
					</button>
					<button type="button" class="btn btn-success btn-small btn-sm" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADD_NEW_PAGE');?>"
						onclick="document.questionForm.pid.value=0;CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.addpage', 'onBeforeAddPage', 'onAfterAddPage'); return false;">
						<i class="fa fa-plus-circle"></i>
					</button>
					<button type="button" class="btn btn-danger btn-small btn-sm" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_DELETE_PAGE');?>"
						onclick="CjSurveyApi.submitAjaxForm(this, '#questionForm', 'question.deletepage', 'onBeforeDeletePage', 'onAfterDeletePage'); return false;">
						<i class="fa fa-trash-o"></i>
					</button>
				</div>
				
				<button type="button" class="btn btn-default btn-small btn-sm btn-reorder-pages" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_REORDER_PAGES');?>">
					<i class="fa fa-cogs"></i>
				</button>
			</div>
			
			<div class="panel-group questions" id="questions" role="tablist" aria-multiselectable="true">
				<?php 
				if(!empty($this->questions))
				{
					foreach ($this->questions as $question)
					{
						echo SurveyHelper::renderLayout($layout.'.form.question', array('item'=>$question, 'pages'=>$this->pages, 'params'=>$params, 'state'=>$this->state));
					}
				}	
				?>
			</div>
		</div>
		
		<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys'); ?>" name="questionForm" id="questionForm" method="post">
			<input type="hidden" name="option" value="com_communitysurveys">
			<input type="hidden" name="view" value="question">
			<input type="hidden" name="task" value="question.add">
			<input type="hidden" name="survey_id" value="<?php echo $this->item->id;?>">
			<input type="hidden" name="pid" value="<?php echo $this->pid;?>">
			<input type="hidden" name="qtype" value="0">
			<input type="hidden" name="id" value="0">
			<input type="hidden" name="newpid" value="0">
			<input type="hidden" name="newtitle" value="0">
		</form>
		<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys'); ?>" name="adminForm" id="adminForm" method="post">
			<input type="hidden" name="option" value="com_communitysurveys">
			<input type="hidden" name="view" value="survey">
			<input type="hidden" name="task" value="">
			<input type="hidden" name="id" value="<?php echo $this->item->id;?>">
			<?php echo JHtml::_('form.token'); ?>
		</form>
	</div>
	
	<div id="modalMoveQuestion" class="modal fade" style="display: none;">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_MOVE_QUESTION_TO_PAGE')?></h4>
				</div>
				<div class="modal-body" style="padding: 1%;">
					<p class="move-question-text"></p>
					<p><?php echo JText::_('COM_COMMUNITYSURVEYS_SELECT_PAGE_TO_MOVE');?></p>
					<select name="all-pages"></select>
					<br><br><br><br>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JCANCEL');?></button>
					<button type="button" class="btn btn-primary btn-confirm-move-question"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONFIRM_MOVE')?></button>
					<button type="button" class="btn btn-primary btn-confirm-copy-question"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONFIRM_COPY')?></button>
				</div>
			</div>
		</div>
	</div>
	
	<div id="modalReorderPages" class="modal fade" style="display: none;">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_REORDER_PAGES')?></h4>
				</div>
				<div class="modal-body" style="padding: 1%;">
					<ul class="list-group reorder-pages-list" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT')?>" class="btn-sort-page" data-toggle="tooltip" style="width: 80%;">
					<?php 
					if(!empty($this->pages))
					{
						foreach ($this->pages as $page)
						{
							?>
							<li class="list-group-item sortpage">
								<i class="fa fa-crosshairs"></i> <?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $page->title, array('jsSafe'=>true)).' (ID: '.$page->id.')';?>
								<input type="hidden" name="sortpageid" value="<?php echo $page->id;?>">
							</li>
							<?php
						}
					}
					?>
					</ul>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JCANCEL');?></button>
					<button type="button" class="btn btn-primary btn-corfirm-reorder-pages"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_REORDER')?></button>
				</div>
			</div>
		</div>
	</div>
	
	<form id="file-upload-form" action="<?php echo JRoute::_('index.php?option=com_communitysurveys');?>" 
		enctype="multipart/form-data" method="post" style="position:absolute; top:-1000px;">
		<input type="file" name="input-attachment" id="input-file-upload">
		<input type="hidden" name="view" value="question">
		<input type="hidden" name="task" value="question.upload">
	</form>
	
	<div style="display: none;">
		<span id="msg-confirm-alert"><?php echo JText::_('COM_COMMUNITYSURVEYS_CONFIRM_ALERT');?></span>
		<div id="progress-message"><h3><i class="fa fa-spinner fa-spin"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PROGRESS_LOADING_MESSAGE');?></h3></div>
		<input type="hidden" name="cjpageid" id="cjpageid" value="questions_form">
		<input type="hidden" name="return" value="<?php echo $this->return_page; ?>" />
		<span id="textMoveQuestion"><?php echo JText::_('COM_COMMUNITYSURVEYS_MOVE_QUESTION_TEXT');?></span>
		<span id="textCopyQuestion"><?php echo JText::_('COM_COMMUNITYSURVEYS_COPY_QUESTION_TEXT');?></span>
		<span id="textPromptPageTitle"><?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_NEW_PAGE_TITLE');?></span>
	</div>
</div>