<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewSurvey extends JViewLegacy
{
	protected $form;

	protected $item;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		if ($this->getLayout() == 'pagebreak')
		{
			// TODO: This is really dogy - should change this one day.
			$input = JFactory::getApplication()->input;
			$eName = $input->getCmd('e_name');
			$eName    = preg_replace('#[^A-Z0-9\-\_\[\]]#i', '', $eName);
			$document = JFactory::getDocument();
			$document->setTitle(JText::_('COM_COMMUNITYSURVEYS_PAGEBREAK_DOC_TITLE'));
			$this->eName = &$eName;
			parent::display($tpl);
			return;
		}

		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->canDo	= JHelperContent::getActions('com_communitysurveys', 'survey', $this->item->id);
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
		
		if ($this->getLayout() == 'modal')
		{
			$this->form->setFieldAttribute('language', 'readonly', 'true');
			$this->form->setFieldAttribute('catid', 'readonly', 'true');
		}

		if($this->getLayout() == 'questions')
		{
			if(empty($this->item) || !$this->item->id)
			{
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').': RC=1', 403);
			}
			
			JLoader::import('joomla.application.component.model');
			JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
			JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');

			$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
			$state = $questionsModel->getState(); // access the state first so that it can be modified
			$pages = $questionsModel->getPages($this->item->id);
			$pid = 0;
			if(!empty($pages) && isset($pages[0]))
			{
				$pid = $pages[0]->id;
			}
		
			$questionsModel->setState('filter.survey_id', $this->item->id);
			$questionsModel->setState('filter.category_id', 0);
			$questionsModel->setState('filter.page_id', $pid);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('list.ordering', 'a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			
			$this->questions = &$questions;
			$this->pages = &$pages;
			$this->pid = $pid;
		}
		
		if($this->getLayout() == 'preview')
		{
			JLoader::import('joomla.application.component.model');
			JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
			JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
			
			$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
			$state = $questionsModel->getState(); // access the state first so that it can be modified
			$pages = $questionsModel->getPages($this->item->id);
			
			$questionsModel->setState('filter.survey_id', $this->item->id);
			$questionsModel->setState('filter.category_id', 0);
			$questionsModel->setState('filter.page_id', 0);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('list.ordering', 'a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			
			$this->questions = &$questions;
			$this->pages = &$pages;
			$this->item->params = $this->params = JComponentHelper::getParams('com_communitysurveys');
			
			$app = JFactory::getApplication();
			$app->input->set('tmpl', 'component');
			$app->input->set('format', 'raw');
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);

		// Built the actions for new and existing records.
		$canDo		= $this->canDo;
		
		$pageTitle = JText::_('COM_COMMUNITYSURVEYS_PAGE_' . ($checkedOut ? 'VIEW_SURVEY' : ($isNew ? 'ADD_SURVEY' : 'EDIT_SURVEY')));
		JToolbarHelper::title($pageTitle . ' (' . CjLibUtils::escape($this->item->title) . ')', 'pencil-2 survey-add');

		// For new records, check the create permission.
		if ($isNew && (count($user->getAuthorisedCategories('com_communitysurveys', 'core.create')) > 0))
		{
			if($this->getLayout() != 'questions')
			{
				JToolbarHelper::apply('survey.apply');
				JToolbarHelper::save('survey.save');
				JToolbarHelper::save2new('survey.save2new');
			}
			JToolbarHelper::cancel('survey.cancel');
		}
		else
		{
			if($this->getLayout() != 'questions')
			{
				// Can't save the record if it's checked out.
				if (!$checkedOut)
				{
					// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
					if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId))
					{
						JToolbarHelper::apply('survey.apply');
						JToolbarHelper::save('survey.save');
	
						// We can save this record, but check the create permission to see if we can return to make a new one.
						if ($canDo->get('core.create'))
						{
							JToolbarHelper::save2new('survey.save2new');
						}
					}
				}
	
				// If checked out, we can still save
				if ($canDo->get('core.create'))
				{
					JToolbarHelper::save2copy('survey.save2copy');
				}
	
				if ($this->state->params->get('save_history', 0) && $canDo->get('core.edit'))
				{
					JToolbarHelper::versions('com_communitysurveys.survey', $this->item->id);
				}
			}
			
			JToolbarHelper::cancel('survey.cancel', 'JTOOLBAR_CLOSE');
		}

		JToolbarHelper::divider();
	}
}
