<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
$span 		= !empty( $this->sidebar) ? 'col-md-10' : 'col-md-12';
$sortFields = $this->getSortFields();
$htmlFields = array(CS_TRANSLATION_SURVEY_DESC, CS_TRANSLATION_SURVEY_ENDTEXT, CS_TRANSLATION_SURVEY_HEADER, CS_TRANSLATION_QUESTION_DESC);
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<div class="row" id="cj-wrapper">
    <?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="col-md-2">
    	<?php echo $this->sidebar; ?>
    </div>
    <?php endif;?>
    <div class="<?php echo $span;?>">
    	<div id="j-main-container">
			<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=translations&survey_id='.$this->survey_id.'&language='.$this->language); ?>" method="post" name="adminForm" id="adminForm">
        		<?php
        		// Search tools bar
        		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
        		?>
        		<?php if (empty($this->items)) : ?>
        			<div class="alert alert-no-items">
        				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
        			</div>
        		<?php else : ?>
        			<table class="table table-striped" id="translationList">
        				<thead>
        					<tr>
        						<th width="1%" class="hidden-phone hidden-xs">
        							<?php echo JHtml::_('grid.checkall'); ?>
        						</th>
        						<th width="1%" style="min-width:55px" class="nowrap text-center">
        							<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
        						</th>
        						<th>
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_HEADING_ITEM_TYPE', 'a.item_type', $listDirn, $listOrder); ?>
        						</th>
        						<th width="35%">
        							<?php echo JText::_('COM_COMMUNITYSURVEYS_HEADING_SOURCE_STRING');?>
        						</th>
        						<th width="35%">
        							<?php echo JText::_('COM_COMMUNITYSURVEYS_HEADING_TRANSLATION');?>
        						</th>
        						<th width="5%" class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_LANGUAGE', 'language', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_HEADING_SURVEY_ID', 'a.survey_id', $listDirn, $listOrder); ?>
        						</th>
        						<th width="1%" class="nowrap hidden-phone hidden-xs">
        							<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
        						</th>
        					</tr>
        				</thead>
        				<tbody>
        				<?php foreach ($this->items as $i => $item) :
        					$item->max_ordering = 0; //??
        					$canChange  = $user->authorise('core.edit.state', 'com_communitysurveys');
        					?>
        					<tr class="row<?php echo $i % 2; ?>">
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
        						</td>
        						<td class="text-center">
        							<div class="btn-group">
        								<?php echo JHtml::_('jgrid.published', $item->published, $i, 'translations.', $canChange, 'cb', '0000-00-00 00:00:00', '0000-00-00 00:00:00'); ?>
        								<?php
        								$action = $trashed ? 'untrash' : 'trash';
        								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'translations');
        
        								// Render dropdown list
        								echo JHtml::_('actionsdropdown.render', $this->escape($item->language));
        								?>
        							</div>
        						</td>
        						<td class="has-context">
        							<?php 
        							echo CommunitySurveysHelper::getTranslationTypeTitle($item->item_type); 
        							if($item->item_type == CS_TRANSLATION_QUESTION_DESC || $item->item_type == CS_TRANSLATION_ANSWER_TITLE) 
        							{
        							    echo ' <small>('.$this->escape($item->question_title).')</small>';
        							}
        							?>
        						</td>
        						<td>
        							<?php echo $this->escape($item->source_value); ?>
        						</td>
        						<td class="editable-parent" data-id="<?php echo $item->id;?>">
        							<a href="#" class="editable<?php echo empty(strip_tags($item->translation)) ? ' editable-empty' : '';?>" data-type="<?php echo in_array($item->item_type, $htmlFields) ? 'textarea' : 'text';?>">
        								<?php 
        								if(empty(strip_tags($item->translation)))
        								{
        								    echo JText::_('COM_COMMUNITYSURVEYS_EMPTY');
        								}
        								else if(in_array($item->item_type, $htmlFields)) 
        								{
        								    echo $item->translation;
        								}
        								else 
        								{
        								    echo $this->escape($item->translation);
        								}
        								?>
        							</a>
        						</td>
        						<td>
        							<?php echo $this->escape($item->language); ?>
        						</td>
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo (int) $item->survey_id; ?>
        						</td>
        						<td class="text-center hidden-phone hidden-xs">
        							<?php echo (int) $item->id; ?>
        						</td>
        					</tr>
        					<?php endforeach; ?>
        				</tbody>
        			</table>
        		<?php endif; ?>
        		<?php echo $this->pagination->getListFooter(); ?>
        
        		<input type="hidden" id="cjpageid" value="translations">
        		<input type="hidden" name="task" value="" />
        		<input type="hidden" name="boxchecked" value="0" />
        		<?php echo JHtml::_('form.token'); ?>
			</form>
			
			<div style="display: none;">
				<div id="tpl-editable-text">
					<div class="editable-form form-inline">
    					<input name="editable-input" type="text" class="editable-input" value=""/>
    					<button type="button" class="btn btn-primary btn-save"><i class="fa fa-check"></i> <?php echo JText::_('JSAVE')?></button>
    					<button type="button" class="btn btn-default btn-cancel"><i class="fa fa-times"></i> <?php echo JText::_('JCANCEL')?></button>
					</div>
				</div>
				<div id="tpl-editable-textarea">
					<div class="editable-form form-inline">
    					<textarea name="editable-input" class="editable-input" rows="3" cols="50"></textarea>
    					<button type="button" class="btn btn-primary btn-save"><i class="fa fa-check"></i> <?php echo JText::_('JSAVE')?></button>
    					<button type="button" class="btn btn-default btn-cancel"><i class="fa fa-times"></i> <?php echo JText::_('JCANCEL')?></button>
					</div>
				</div>
				<div id="url-save-translation"><?php echo JRoute::_('index.php?option=com_communitysurveys&task=translation.save&survey_id='.$this->survey_id);?></div>
			</div>
		</div>
	</div>
</div>
