<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurvey
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerResponse extends JControllerAdmin
{

	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	private $_captchaValidated = false;
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}

	public function execute ($task)
	{
		try
		{
			switch ($task)
			{
				case 'create':
					$this->create();
					break;
					
				case 'next':
					$this->next();
					break;
					
				case 'jump':
					$this->jump();
					break;

				case 'save':
					$this->save();
					break;

				case 'previous':
					$this->previous();
					break;
					
				default:
					throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=1', 403);
			}
		}
		catch (Exception $e)
		{
			echo new JResponseJson($e);
		}
		
		JFactory::getApplication()->close();
	}
	
	private function create($showNext = true)
	{
		$app 			= JFactory::getApplication();
		$user 			= JFactory::getUser();
		$surveyId 		= $app->input->getInt('id', 0);
		
		// first get the survey
		if(!$surveyId || !$user->authorise('core.respond', 'com_communitysurveys.survey.'.$surveyId))
		{
			throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_UNAUTHORIZED').'| RC=101', 403);
		}
		
// 		$surveyModel 	= $this->getModel('survey', 'CommunitySurveysModel');
// 		$surveyModel->getState(); // access the state first so that it can be modified
		
// 		$surveyModel->setState('filter.survey_id', $surveyId);
// 		$survey 		= $surveyModel->getItem($surveyId);
		
		if(!$this->_captchaValidated)
		{
    		$this->_captchaValidated = $this->isCaptchaValid();
    		if(!$this->_captchaValidated)
    		{
    			throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_INVALID_CAPTCHA'), 403);
    		}
		}
		
		$model = $this->getModel('response');
		$response = $model->createOrUpdateResponse($surveyId);
		if (!$response || !$response->response_id)
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'), 500);
		}
		
		$app->setUserState('com_communitysurveys.response.'.$response->response_id, $response);
		
		if($showNext)
		{
			$this->showNextPage($response->response_id, false, $response->curr_page);
		}
		else 
		{
			return $response;
		}
	}
	
	private function previous ()
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$surveyId = $app->input->getInt('id', 0);
		$responseId = $app->input->getInt('rid', 0);
		
		// first get the survey
		if(!$surveyId || !$responseId || !$user->authorise('core.respond', 'com_communitysurveys.survey.'.$surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=102', 403);
		}
		
		$model = $this->getModel('response');
		if (!$model->save())
		{
			// probably user did't select any answer.
		}
		
		$this->showNextPage($responseId, true);
	}
	
	private function save ()
	{
		$app 			= JFactory::getApplication();
		$user 			= JFactory::getUser();
		$surveyId 		= $app->input->getInt('id', 0);
		$responseId 	= $app->input->getInt('rid', 0);
		
		if(!$responseId)
		{
			$response = $this->create(false);
			$responseId = $response->response_id;
			$app->input->set('rid', $responseId);
		}
		
		// first get the survey
		if(!$surveyId || !$responseId || !$user->authorise('core.respond', 'com_communitysurveys.survey.'.$surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=103', 403);
		}
		
		$model = $this->getModel('response');
		$model->setState('update_curr_page', false);
		
		if (!$model->save())
		{
			// probably user did't select any answer.
		}
		
		echo new JResponseJson(1);
	}
	
	private function jump()
	{
		$app	= JFactory::getApplication();
		$pageId = $app->input->getInt('jumptopageid', 0);
		$this->next($pageId);
	}

	private function next ($pageId = 0)
	{
		$app 			= JFactory::getApplication();
		$user 			= JFactory::getUser();
		$surveyId 		= $app->input->getInt('id', 0);
		$responseId 	= $app->input->getInt('rid', 0);
		
		if(!$responseId)
		{
			$response = $this->create(false);
			$responseId = $response->response_id;
			$app->input->set('rid', $responseId);
		}
		
		// first get the survey
		if(!$surveyId || !$responseId || !$user->authorise('core.respond', 'com_communitysurveys.survey.'.$surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=103'.$surveyId, 403);
		}
		
		if(!$this->_captchaValidated)
		{
		    $this->_captchaValidated = $this->isCaptchaValid();
		    if(!$this->_captchaValidated)
		    {
		        throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_INVALID_CAPTCHA'), 403);
		    }
		}
		
		$model = $this->getModel('response');
		$return = $model->save();
		
		if(!empty($return->finalize))
		{
			$surveyModel = $this->getModel('survey');
			$survey = $surveyModel->getItem($surveyId);
			$this->finalizeResponse($survey, $responseId);
		}
		else if($pageId)
		{
			$this->showNextPage($responseId, false, $pageId);
		}
		else if(!empty($return->page_id))
		{
			$this->showNextPage($responseId, false, $return->page_id);
		}
		else 
		{
			$this->showNextPage($responseId);
		}
	}
	
	private function showNextPage($responseId = null, $showPrevious = false, $pageId = 0)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$surveyId = $app->input->getInt('id', 0);
		$responseId = !$responseId ? $app->input->getInt('rid', 0) : $responseId;
		$pagination = null;
		$nextPageId = 0;
		
		// first get the survey
		if(!$surveyId || !$responseId || !$user->authorise('core.respond', 'com_communitysurveys.survey.'.$surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=104', 403);
		}
		
		$surveyModel = $this->getModel('survey');
		$survey = $surveyModel->getItem($surveyId);
		
		$model = $this->getModel('response');
		$pagination = $model->getPagination($pageId);
		
		$nextPageId = $pageId ? $pageId : ($showPrevious ? $pagination->getPrevPageId() : $pagination->getNextPageId());
		$pagination->setActivePageId($nextPageId);
		
		if (!$nextPageId)
		{
			// finalize response and return
			$this->finalizeResponse($survey, $responseId);
			return;
		}

		// check if the timer expired
		$response = $app->getUserState('com_communitysurveys.response.'.$responseId);
		$questionsModel	= $this->getModel('questions');
		$state = $questionsModel->getState(); // access the state first so that it can be modified
			
		$order 		= 'a.survey_id, a.sort_order';
		$limit 		= 0;
		$catid 		= 0;
		$surveyId 	= (int) $survey->id;
		$unique 	= false;
			
		$questionsModel->setState('filter.survey_id', $surveyId);
		$questionsModel->setState('filter.category_id', $catid);
		$questionsModel->setState('filter.page_id', $nextPageId);
		$questionsModel->setState('filter.question_id', null);
		$questionsModel->setState('filter.unique', $unique);
		$questionsModel->setState('filter.response_id', $responseId);
		$questionsModel->setState('list.ordering', $order);
		$questionsModel->setState('list.direction', 'asc');
		$questionsModel->setState('list.limit', $limit);
		$questionsModel->setState('question.replace_placeholders', true);
		$questions = $questionsModel->getItems();

		$output = '';
		$paginationHtml = '';
		if(!empty($questions))
		{
			$data 				= new stdClass();
			$data->item 		= $survey;
			$data->pagination 	= $pagination;
			$data->response 	= $response;
			$data->state 		= $surveyModel->getState();
			$data->params 		= $state ? $state->params : JComponentHelper::getParams('com_communitysurveys');
			$layout 			= $data->params->get('ui_layout', 'default');
			$paginationHtml 	= SurveyHelper::renderLayout($layout.'.response.pagination', array('data'=>$data));
			
			foreach ($questions as $question)
			{
				$output = $output . SurveyHelper::renderLayout($layout.'.response.question', array('data'=>$data, 'question'=>$question));
			}
		}
		
		$output = $output . '<input type="hidden" name="pid" value="'.$nextPageId.'">';
		$output = $output . '<input type="hidden" name="rid" value="'.$responseId.'">';
			
		$return = new stdClass();
		$return->responseId = $responseId;
		$return->html = $output;
		$return->pagination = $paginationHtml;
		$return->hasNext = ($pagination && ( $showPrevious ? 1 : ($pageId ? $pagination->getNextPageId() : $pagination->getLaterPageId()) ) > 0) ? true : false;
		$return->hasPrev = ($pagination && ( $showPrevious ? $pagination->getLaterPrevPageId() : ($pageId ? $pagination->getPrevPageId() : $pagination->getCurrPageId())) > 0 ) ? true : false;
		$return->finished = false;

		echo new JResponseJson($return);
	}
	
	private function finalizeResponse($survey, $responseId)
	{
		$user 					= JFactory::getUser();
		$model 					= $this->getModel('response');
		$survey->result 		= $model->finalize($survey, $responseId);
		$return 				= new stdClass();
		$return->redirect_url 	= '';
		$params 				= JComponentHelper::getParams('com_communitysurveys');
		$layout 				= $params->get('ui_layout', 'default');
		
		if(!$survey->result)
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'), 500);
		}
		
		$output =  SurveyHelper::renderLayout($layout.'.results.message', array('item'=>$survey));
		
		if($survey->params->get('show_report', 0) == 1 && $user->authorise('core.results', 'com_communitysurveys.survey.'.$survey->id))
		{
			$questionsModel	= $this->getModel('questions');
			$questionsModel->getState();
			$questionsModel->setState('filter.survey_id', $survey->id);
			$questionsModel->setState('filter.category_id', null);
			$questionsModel->setState('filter.page_id', 0);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('filter.unique', false);
			$questionsModel->setState('filter.response_id', $responseId);
			$questionsModel->setState('list.ordering', 'p.sort_order asc, a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			
			$app = JFactory::getApplication();
			$app->setUserState('result.stats', array());
			
			foreach ($questions as $question)
			{
			    $question->rid 	= $responseId;
				$output 		= $output . SurveyHelper::renderLayout($layout.'.results.question', array('item'=>$question, 'params'=>$params, 'rid'=>$responseId));
			}
			
			$stats = $app->getUserState('result.stats');
			$output = SurveyHelper::renderLayout($layout.'.results.stats', array('stats'=>$stats)) . $output;
		}
		else if(!empty($survey->redirect_url))
		{
		    if(JString::parse_url($survey->redirect_url))
		    {
		        $return->redirect_url = $survey->redirect_url;
		    }
		}
		
		$return->responseId = $responseId;
		$return->html = $output;
		$return->pagination = '';
		$return->hasNext = false;
		$return->hasPrev = false;
		$return->finished = true;
		
		echo new JResponseJson($return, '', false);
	}
	
	private function isCaptchaValid()
	{
		$appParams = JComponentHelper::getParams('com_communitysurveys');
		if($appParams->get('enable_captcha', 0))
		{
			$app = JFactory::getApplication();
			$captchaField = $app->input->getString('captcha-field');
			if(!empty($captchaField))
			{
				JPluginHelper::importPlugin('captcha');
				$captcha = $app->input->getString('g-recaptcha-response', '');
				$result = $app->triggerEvent('onCheckAnswer', array($captcha));

				if(isset($result[0]) && !$result[0])
				{
					return false;
				}
			}
		}
		
		return true;
	}
}