<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysControllerSurvey extends JControllerAdmin
{

	protected $text_prefix = 'COM_COMMUNITYSURVEYS';

	public function __construct ($config = array())
	{
		parent::__construct($config);
	}

	public function execute ($task)
	{
		try
		{
			switch ($task)
			{
				case 'order_questions':
					$this->orderQuestions();
					break;
					
				case 'load_survey':
					$this->loadSurvey();
					break;
			}
		}
		catch (Exception $e)
		{
			echo new JResponseJson($e);
		}
	}
	
	private function orderQuestions ()
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$surveyId = $app->input->getInt('id', 0);
		
		// first get the survey
		if (! $surveyId || ! $user->authorise('core.respond', 'com_communitysurveys.survey.' . $surveyId))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR') . '| RC=1', 403);
		}
		
		$model = $this->getModel('response');
		$response = $model->createOrUpdateResponse($surveyId);
		if (! $response || ! $response->response_id)
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'), 500);
		}
		
		$app->setUserState('com_communitysurveys.response.' . $response->response_id, $response);
		$this->showNextPage($response->response_id);
	}
}