<?php
/**
 * @package     corejoomla.site
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysRouterRulesLegacy implements JComponentRouterRulesInterface
{
	public function __construct($router)
	{
		$this->router = $router;
	}
	
	public function preprocess(&$query)
	{}
	
	public function build(&$query, &$segments)
	{
	    // Get a menu item based on Itemid or currently active
	    $app = JFactory::getApplication();
	    $menu = $app->getMenu();
	    $params = JComponentHelper::getParams('com_communitysurveys');
	    $advanced = $params->get('sef_advanced_link', 0);
	    
	    // We need a menu item.  Either the one specified in the query, or the current active one if none specified
	    if (empty($query['Itemid']))
	    {
	        $menuItem = $menu->getActive();
	        $menuItemGiven = false;
	    }
	    else
	    {
	        $menuItem = $menu->getItem($query['Itemid']);
	        $menuItemGiven = true;
	    }
	    
	    // Check again
	    if ($menuItemGiven && isset($menuItem) && $menuItem->component != 'com_communitysurveys')
	    {
	        $menuItemGiven = false;
	        unset($query['Itemid']);
	    }
	    
	    if (isset($query['view']))
	    {
	        $view = $query['view'];
	    }
	    else
	    {
	        // We need to have a view in the query or it is an invalid URL
	        return $segments;
	    }
	    
	    // Are we dealing with an survey or category that is attached to a menu item?
	    if (
	        ($menuItem instanceof stdClass) &&
	        ($menuItem->query['view'] == $query['view']) &&
	        isset($query['id']) &&
	        isset($menuItem->query['id']) &&
	        ($menuItem->query['id'] == (int) $query['id'])
	        )
	    {
	        unset($query['view']);
	        
	        if (isset($query['catid']))
	        {
	            unset($query['catid']);
	        }
	        
	        if (isset($query['layout']))
	        {
	            unset($query['layout']);
	        }
	        
	        unset($query['id']);
	        return $segments;
	    }
	    
	    switch ($view)
	    {
	        case 'category':
	        case 'survey':
	            
	            if (!$menuItemGiven)
	            {
	                $segments[] = $view;
	            }
	            
	            unset($query['view']);
	            
	            if ($view == 'survey')
	            {
	                if (isset($query['id']) && isset($query['catid']) && $query['catid'])
	                {
	                    $catid = $query['catid'];
	                    
	                    // Make sure we have the id and the alias
	                    if (strpos($query['id'], ':') === false)
	                    {
	                        $db = JFactory::getDbo();
	                        $dbQuery = $db->getQuery(true)
	                        ->select('alias')
	                        ->from('#__survey_surveys')
	                        ->where('id=' . (int) $query['id']);
	                        $db->setQuery($dbQuery);
	                        $alias = $db->loadResult();
	                        $query['id'] = $query['id'] . ':' . $alias;
	                    }
	                }
	                else
	                {
	                    // We should have these two set for this view.  If we don't, it is an error
	                    return $segments;
	                }
	            }
	            else
	            {
	                if (isset($query['id']))
	                {
	                    $catid = $query['id'];
	                }
	                else
	                {
	                    // We should have id set for this view.  If we don't, it is an error
	                    return $segments;
	                }
	            }
	            
	            if ($menuItemGiven && isset($menuItem->query['id']))
	            {
	                $mCatid = $menuItem->query['id'];
	            }
	            else
	            {
	                $mCatid = 0;
	            }
	            
	            $categories = JCategories::getInstance('CommunitySurveys');
	            $category = $categories->get($catid);
	            
	            if (!$category)
	            {
	                // We couldn't find the category we were given.  Bail.
	                return $segments;
	            }
	            
	            $path = array_reverse($category->getPath());
	            $array = array();
	            
	            foreach ($path as $i => $id)
	            {
	                if ((int) $id == (int) $mCatid)
	                {
	                    break;
	                }
	                
	                list($tmp, $id) = explode(':', $id, 2);
	                $array[] = $id;
	            }
	            
	            $array = array_reverse($array);
	            
	            if (!$advanced && count($array))
	            {
	                $array[0] = (int) $catid . ':' . $array[0];
	            }
	            
	            $segments = array_merge($segments, $array);
	            if ($view == 'survey')
	            {
	                if ($advanced)
	                {
	                    list($tmp, $id) = explode(':', $query['id'], 2);
	                }
	                else
	                {
	                    $id = $query['id'];
	                }
	                
	                $segments[] = $id;
	            }
	            
	            unset($query['id']);
	            unset($query['catid']);
	            
	            break;
	            
	        case 'activities':
	        case 'surveys':
	        case 'leaderboard':
	        case 'users':
	            
	            if (!$menuItemGiven)
	            {
	                $segments[] = $view;
	                unset($query['view']);
	            }
	            else if($query['view'] == $menuItem->query['view'])
	            {
	                unset($query['view']);
	            }
	            
	            break;
	            
	        case 'archive':
	            
	            if (!$menuItemGiven)
	            {
	                $segments[] = $view;
	                unset($query['view']);
	            }
	            
	            if (isset($query['year']))
	            {
	                if ($menuItemGiven)
	                {
	                    $segments[] = $query['year'];
	                    unset($query['year']);
	                }
	            }
	            
	            if (isset($query['year']) && isset($query['month']))
	            {
	                if ($menuItemGiven)
	                {
	                    $segments[] = $query['month'];
	                    unset($query['month']);
	                }
	            }
	            
	            break;
	            
	        case 'featured':
	            
	            if (!$menuItemGiven)
	            {
	                $segments[] = $view;
	            }
	            
	            unset($query['view']);
	            
	            break;
	    }
	    
	    /*
	     * If the layout is specified and it is the same as the layout in the menu item, we
	     * unset it so it doesn't go into the query string.
	     */
	    if (isset($query['layout']))
	    {
	        if ($menuItemGiven && isset($menuItem->query['layout']))
	        {
	            if ($query['layout'] == $menuItem->query['layout'])
	            {
	                unset($query['layout']);
	            }
	        }
	        else
	        {
	            if ($query['layout'] == 'default')
	            {
	                unset($query['layout']);
	            }
	        }
	    }
	    
	    $total = count($segments);
	    
	    for ($i = 0; $i < $total; $i++)
	    {
	        $segments[$i] = str_replace(':', '-', $segments[$i]);
	    }
	    
	    return $segments;
	}

	public function parse(&$segments, &$vars)
	{
	    $app = JFactory::getApplication();
	    $db = JFactory::getDbo();
	    $total = count($segments);
	    
	    for ($i = 0; $i < $total; $i++)
	    {
	        $segments[$i] = preg_replace('/-/', ':', $segments[$i], 1);
	    }
	    
	    // Count route segments
	    $count = count($segments);

	    // old urls redirection
	    if($count == 2)
	    {
	        try
	        {
	            switch ($segments[0])
	            {
	                case 'take_survey': //survey
	                    $surveyId = (int) $segments[1];
	                    
	                    // get survey details and redirect
	                    $query = $db->getQuery(true)
	                    ->select('a.id, a.alias, a.catid, c.alias as category_alias, a.language')
	                    ->from('#__survey_surveys AS a')
	                    ->join('inner', '#__categories AS c ON a.catid = c.id')
	                    ->where('a.id = '.$surveyId);
	                    
	                    $db->setQuery($query);
	                    $survey = $db->loadObject();
	                    
	                    if($survey)
	                    {
	                        JLoader::register('CommunitySurveysHelperRoute', JPATH_BASE . '/components/com_communitysurveys/helpers/route.php');
	                        $slug = $survey->alias ? ($survey->id . ':' . $survey->alias) : $survey->id;
	                        $catslug = $survey->category_alias ? ($survey->catid . ':' . $survey->category_alias) : $survey->catid;
	                        
	                        $app->redirect(JRoute::_(CommunitySurveysHelperRoute::getSurveyRoute($slug, $catslug, $survey->language)), '', 'message', true);
	                        return;
	                    }
	                    
	                    break;
	            }
	        }
	        catch (Exception $e){}
	    }
	    
	    $menu = $app->getMenu();
	    $item = $menu->getActive();
	    
	    /*
	     * Standard routing for surveys.  If we don't pick up an Itemid then we get the view from the segments
	     * the first segment is the view and the last segment is the id of the survey or category.
	     */
	    if (!isset($item))
	    {
	        $vars['view'] = $segments[0];
	        $vars['id'] = $segments[$count - 1];
	        
	        return $vars;
	    }
	    
	    $params = JComponentHelper::getParams('com_communitysurveys');
	    $advanced = $params->get('sef_advanced_link', 0);
	    
	    /*
	     * If there is only one segment, then it points to either an survey or a category.
	     * We test it first to see if it is a category.  If the id and alias match a category,
	     * then we assume it is a category.  If they don't we assume it is an survey
	     */
	    if ($count == 1)
	    {
	        // We check to see if an alias is given.  If not, we assume it is an survey
	        if (strpos($segments[0], ':') === false)
	        {
	            $vars['view'] = 'survey';
	            $vars['id'] = (int) $segments[0];
	            
	            return $vars;
	        }
	        
	        list($id, $alias) = explode(':', $segments[0], 2);

	        // First we check if it is a category
	        $category = JCategories::getInstance('CommunitySurveys')->get($id);

	        if ($category && $category->alias == $alias)
	        {
	            $vars['view'] = 'category';
	            $vars['id'] = $id;

	            return $vars;
	        }
	        else
	        {
	            try
	            {
	                $query = $db->getQuery(true)
	                ->select($db->quoteName(array('alias', 'catid')))
	                ->from($db->quoteName('#__survey_surveys'))
	                ->where($db->quoteName('id') . ' = ' . (int) $id);
	                $db->setQuery($query);
	                $survey = $db->loadObject();
	                
	                if ($survey)
	                {
	                    if ($survey->alias == $alias)
	                    {
	                        $vars['view'] = 'survey';
	                        $vars['catid'] = (int) $survey->catid;
	                        $vars['id'] = (int) $id;
	                        
	                        return $vars;
	                    }
	                }
	            }
	            catch (Exception $e){}
	        }
	    }
	    
	    /*
	     * If there was more than one segment, then we can determine where the URL points to
	     * because the first segment will have the target category id prepended to it.  If the
	     * last segment has a number prepended, it is an survey, otherwise, it is a category.
	     */
	    if (!$advanced)
	    {
	        $cat_id = (int) $segments[0];
	        
	        $survey_id = (int) $segments[$count - 1];
	        
	        if ($survey_id > 0)
	        {
	            $vars['view'] = 'survey';
	            $vars['catid'] = $cat_id;
	            $vars['id'] = $survey_id;
	        }
	        else
	        {
	            $vars['view'] = 'category';
	            $vars['id'] = $cat_id;
	        }
	        
	        return $vars;
	    }
	    
	    // We get the category id from the menu item and search from there
	    $id = $item->query['id'];
	    $category = JCategories::getInstance('CommunitySurveys')->get($id);
	    
	    if (!$category)
	    {
	        throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_PARENT_CATEGORY_NOT_FOUND'), 404);
	    }
	    
	    $categories = $category->getChildren();
	    $vars['catid'] = $id;
	    $vars['id'] = $id;
	    $found = 0;
	    
	    foreach ($segments as $segment)
	    {
	        $segment = str_replace(':', '-', $segment);
	        
	        foreach ($categories as $category)
	        {
	            if ($category->alias == $segment)
	            {
	                $vars['id'] = $category->id;
	                $vars['catid'] = $category->id;
	                $vars['view'] = 'category';
	                $categories = $category->getChildren();
	                $found = 1;
	                break;
	            }
	        }
	        
	        if ($found == 0)
	        {
	            $cid = 0;
	            if ($advanced)
	            {
	                try
	                {
	                    $query = $db->getQuery(true)
	                    ->select($db->quoteName('id'))
	                    ->from('#__survey_surveys')
	                    ->where($db->quoteName('catid') . ' = ' . (int) $vars['catid'])
	                    ->where($db->quoteName('alias') . ' = ' . $db->quote($db->quote($segment)));
	                    
	                    $db->setQuery($query);
	                    $cid = $db->loadResult();
	                }
	                catch (Exception $e){}
	            }
	            else
	            {
	                $cid = $segment;
	            }
	            
	            $vars['id'] = $cid;
	            
	            if ($item->query['view'] == 'archive' && $count != 1)
	            {
	                $vars['year'] = $count >= 2 ? $segments[$count - 2] : null;
	                $vars['month'] = $segments[$count - 1];
	                $vars['view'] = 'archive';
	            }
	            else
	            {
	                $vars['view'] = 'survey';
	            }
	        }
	        
	        $found = 0;
	    }
	    
	    return $vars;
	}
}