<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class SurveyPagination extends JObject
{
	// survey type, category or regular
	private $_surveyId = 0;
	
	private $_activePageId = 0;

	private $_currPageId = 0;

	private $_nexPageId = 0;

	private $_prevPageId = 0;
	
	private $_laterPageId = 0;
	
	private $_laterPrevPageId = 0;

	private $_currPageNum = 1;
	
	private $_isNew = false;

	private $_pages = array();

	public function __construct ($surveyId = 0, $currPageId = 0)
	{
		$this->_surveyId = (int) $surveyId;
		$this->_currPageId = (int) $currPageId;
		$this->_isNew = $currPageId ? false : true;
		$this->build();
	}

	public function getPages ()
	{
		return $this->_pages;
	}
	
	public function isNew()
	{
		return $this->_isNew;
	}

	public function getNextPageId ()
	{
		return $this->_nexPageId;
	}
	
	public function getPrevPageId ()
	{
		return $this->_prevPageId;
	}

	public function getCurrPageId ()
	{
		return $this->_currPageId;
	}
	
	public function getLaterPageId ()
	{
		return $this->_laterPageId;
	}
	
	public function getLaterPrevPageId ()
	{
		return $this->_laterPrevPageId;
	}
	
	public function getActivePageId ()
	{
		return $this->_activePageId ? $this->_activePageId : $this->_currPageId;
	}
	
	public function setActivePageId ($pageId)
	{
		$this->_activePageId = $pageId;
	}

	public function getCurrPageNum ()
	{
		if(empty($this->_pages))
		{
			return $this->_currPageNum;
		}
		
		$activePageId = $this->getActivePageId();
		foreach ($this->_pages as $i => $page)
		{
			if ($page->id == $activePageId)
			{
				$this->_currPageNum = $i + 1;
				break;
			}
		}
		
		return $this->_currPageNum;
	}

	private function build ()
	{
		try
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('id, title, sort_order')
				->from('#__survey_pages')
				->where('sid = ' . $this->_surveyId)
				->order('sort_order ASC, id ASC');
			
			$db->setQuery($query);
			$pages = $db->loadObjectList();
			
			$app = JFactory::getApplication();
			$language = $app->input->getCmd('lang', JFactory::getLanguage()->getTag());
			if(!empty($language))
			{
    			JLoader::import('language', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
    			$languageModel = JModelAdmin::getInstance( 'language', 'CommunitySurveysModel' );
    			
    			$translations = $languageModel->getSurveyTranslations($this->_surveyId, $language);
    			if(!empty($translations))
    			{
    			    foreach ($pages as &$page)
    			    {
    			        foreach ($translations as $translation)
    			        {
        			        if($translation->item_type == CS_TRANSLATION_PAGE_TITLE && $page->id == $translation->item_id)
        			        {
        			            if(!empty($translation->translation))
        			            {
        			                $page->title = $translation->translation;
        			            }
        			            break;
        			        }
    			        }
    			    }
    			    unset($page);
    			}
			}
			
			if (! empty($pages))
			{
				if ($this->_currPageId == 0)
				{
					$this->_currPageId = 0;
					$this->_currPageNum = 1;
					
					if (isset($pages[0]))
					{
						$this->_nexPageId = (int) $pages[0]->id;
					}
					
					if(isset($pages[1]))
					{
						$this->_laterPageId = (int) $pages[1]->id;
					}
				}
				else
				{
					$currPageNum = 1;
					foreach ($pages as $i => $page)
					{
						if ($page->id == $this->_currPageId)
						{
							$this->_currPageNum = $currPageNum;
							
							if (isset($pages[$i + 1]))
							{
								$this->_nexPageId = (int) $pages[$i + 1]->id;
							}
							
							if (isset($pages[$i - 1]))
							{
								$this->_prevPageId = (int) $pages[$i - 1]->id;
							}
							
							if(isset($pages[$i - 2]))
							{
								$this->_laterPrevPageId = (int) $pages[$i -2]->id;
							}
							
							if(isset($pages[$i + 2]))
							{
								$this->_laterPageId = (int) $pages[$i + 2]->id;
							}
							
							break;
						}
						
						$currPageNum ++;
					}
					
					reset($pages);
				}
			}
			
			$this->_pages = &$pages;
		}
		catch (Exception $e)
		{
			// do nothing
		}
	}
}