<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

abstract class CommunitySurveysHelperRoute
{

	protected static $lookup = array();

	protected static $lang_lookup = array();

	public static function getSurveyRoute ($id, $catid = 0, $language = 0, $start = 0)
	{
		$categories = JCategories::getInstance('CommunitySurveys');
		$needles = array('survey' => array((int) $id));
		$link = 'index.php?option=com_communitysurveys&view=survey&id=' . $id;
		
		if ((int) $catid > 1)
		{
			$category = $categories->get((int) $catid);
			if ($category)
			{
				$needles['category'] = array_reverse($category->getPath());
				$needles['categories'][] = $needles['category'];
				$link .= '&catid=' . $catid;
			}
		}
		
		if ($language && $language != "*")
		{
		    $link .= '&lang=' . $language;
		    $needles['language'] = $language;
		}
		
		if($start > 0)
		{
			$link .= '&start=' . $start;
		}
		
		// add root category to needles in case there is no corresponding category menu item found.
		$root = $categories->get('root');
		$needles['categories'][] = $root->id;
		
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
		
		return $link;
	}
	
	public static function getCategoryRoute ($catid = 'root', $language = 0)
	{
		$category = null;
		$catids = array();
		
		if ($catid instanceof JCategoryNode)
		{
			$id = $catid->id;
			$category = $catid;
		}
		else
		{
			$id = (int) $catid;
			
			if($id > 0)
			{
				$category = JCategories::getInstance('CommunitySurveys')->get($catid);
			}
		}
		
		$needles = array();
		if ($id < 1)
		{
			$link = 'index.php?option=com_communitysurveys';
			$catids = array(0);
		}
		else
		{
			$link = 'index.php?option=com_communitysurveys&view=category&id=' . $id;
			if ($category instanceof JCategoryNode)
			{
				$catids = array_reverse($category->getPath());
			}
		}
		
		$needles['category'] = $catids;
		$needles['categories'] = $catids;
		
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
			
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
		
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
		
		return $link;
	}

	public static function getFormRoute ($id = 0)
	{
		// Create the link
		if ($id)
		{
			$link = 'index.php?option=com_communitysurveys&task=survey.edit&s_id=' . $id;
		}
		else
		{
			$link = 'index.php?option=com_communitysurveys&task=survey.add';
		}
		
		return $link;
	}

	public static function getSurveysRoute ($id = null, $language = 0)
	{
		$needles = array('surveys' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=surveys';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
		
		return $link;
	}

	public static function getMySurveysRoute ($id = null, $language = 0)
	{
		$needles = array('mysurveys' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=mysurveys';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}

	public static function getMyResponsesRoute ($id = null, $language = 0)
	{
		$needles = array('myresponses' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=myresponses';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}
	
	public static function getLeaderBoardRoute ($id = null, $language = 0)
	{
		$needles = array('leaderboard' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=leaderboard';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}

	public static function getUsersRoute ($language = 0)
	{
		$needles = array('users' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=users';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}

	public static function getSearchRoute ($language = 0)
	{
		$needles = array('search' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=search';
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}

	public static function getReportsRoute ($id, $language = 0)
	{
		$needles = array('report' => array(0));
		$view = JFactory::getApplication()->isAdmin() ? 'reports' : 'report';
		$link = 'index.php?option=com_communitysurveys&view='.$view.'&id='.$id;
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}

	public static function getInviteRoute ($id, $language = 0)
	{
		$needles = array('invite' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=invite&id='.$id;
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}
	
	public static function getResponsesRoute ($language = 0)
	{
	    $needles = array('responses' => array(0));
	    $link = 'index.php?option=com_communitysurveys&view=responses';
	
	    if ($language && $language != "*" && JLanguageMultilang::isEnabled())
	    {
	        self::buildLanguageLookup();
	
	        if (isset(self::$lang_lookup[$language]))
	        {
	            $link .= '&lang=' . self::$lang_lookup[$language];
	            $needles['language'] = $language;
	        }
	    }
	
	    if ($item = self::_findItem($needles))
	    {
	        $link .= '&Itemid=' . $item;
	    }
	
	    return $link;
	}

	public static function getResponseRoute ($surveyId, $responseId, $language = 0)
	{
		$needles = array('response' => array(0));
		$link = 'index.php?option=com_communitysurveys&view=result&id='.$surveyId.'&rid='.$responseId;
	
		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();
	
			if (isset(self::$lang_lookup[$language]))
			{
				$link .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}
	
		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}
	
		return $link;
	}
	
	protected static function buildLanguageLookup ()
	{
		if (count(self::$lang_lookup) == 0)
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('a.sef AS sef')
				->select('a.lang_code AS lang_code')
				->from('#__languages AS a');
			
			$db->setQuery($query);
			$langs = $db->loadObjectList();
			
			foreach ($langs as $lang)
			{
				self::$lang_lookup[$lang->lang_code] = $lang->sef;
			}
		}
	}

	protected static function _findItem ($needles = null)
	{
		$app      = JFactory::getApplication();
		$menus    = $app->getMenu('site');
		$language = isset($needles['language']) ? $needles['language'] : '*';

		// Prepare the reverse lookup array.
		if (!isset(self::$lookup[$language]))
		{
			self::$lookup[$language] = array();
			$component  = JComponentHelper::getComponent('com_communitysurveys');
			
			$attributes = array('component_id');
			$values = array($component->id);

			if ($language != '*')
			{
				$attributes[] = 'language';
				$values[]     = array($needles['language'], '*');
			}

			$items = $menus->getItems($attributes, $values);

			foreach ($items as $item)
			{
				if (isset($item->query) && isset($item->query['view']))
				{
					$view = $item->query['view'];

					if (!isset(self::$lookup[$language][$view]))
					{
						self::$lookup[$language][$view] = array();
					}

					if (isset($item->query['id']))
					{
						/**
						 * Here it will become a bit tricky
						 * language != * can override existing entries
						 * language == * cannot override existing entries
						 */
						if (!isset(self::$lookup[$language][$view][$item->query['id']]) || $item->language != '*')
						{
							self::$lookup[$language][$view][$item->query['id']] = $item->id;
						}
					}
					elseif (in_array($view, array('surveys', 'leaderboard', 'users')))
					{
						if (!isset(self::$lookup[$language][$view][0]) || $item->language != '*')
						{
							self::$lookup[$language][$view][0] = $item->id;
						}
					}
				}
			}
		}
		
		if ($needles)
		{
			foreach ($needles as $view => $ids)
			{
				if (isset(self::$lookup[$language][$view]))
				{
					foreach ($ids as $id)
					{
						if (isset(self::$lookup[$language][$view][(int) $id]))
						{
							return self::$lookup[$language][$view][(int) $id];
						}
					}
				}
			}
		}

		// Check if the active menuitem matches the requested language
		$active = $menus->getActive();

		if ($active && $active->component == 'com_communitysurveys' && ($language == '*' || in_array($active->language, array('*', $language)) || !JLanguageMultilang::isEnabled()))
		{
			return $active->id;
		}

		// If not found, return language specific home link
		$default = $menus->getDefault($language);

		return !empty($default->id) ? $default->id : null;
	}
}
