<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$item 		= $displayData['item'];
$pages 		= $displayData['pages'];
$editor 	= $displayData['editor'];
?>
<div role="tabpanel">
	<ul class="nav nav-tabs" role="tablist" id="tabs-<?php echo $item->id;?>">
		<li class="pull-right">
			<button type="button" class="btn btn-primary" onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.save', 'onBeforeSaveQuestion', 'onAfterSaveQuestion')">
				<?php echo JText::_('JSAVE');?>
			</button>
			<button type="button" class="btn btn-default btn-close-question">
				<?php echo JText::_('JCANCEL');?>
			</button>
		</li>
		<li role="presentation" class="active">
			<a href="#content-<?php echo $item->id?>" aria-controls="#content-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTENT');?>
			</a>
		</li>
		<li role="presentation">
			<a href="#answers-<?php echo $item->id?>" aria-controls="#answers-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTIONS');?>
			</a>
		</li>
		<li role="presentation">
			<a href="#conditions-<?php echo $item->id?>" aria-controls="#conditions-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONDITIONAL_RULES');?>
			</a>
		</li>
		<li role="presentation">
			<a href="#customize-<?php echo $item->id?>" aria-controls="#customize-<?php echo $item->id?>" role="tab" data-toggle="tab" onclick="return false;">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CUSTOMIZE');?>
			</a>
		</li>
	</ul>
	<div class="tab-content">
		<div role="tabpanel" class="tab-pane fade in active" id="content-<?php echo $item->id?>">
			<div class="form-group">
				<label for="title-<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_TITLE');?><sup>*</sup>:</label>
				<input type="text" name="title" id="title-<?php echo $item->id;?>" value="<?php echo $this->escape($item->title);?>" class="input-xlarge required">
			</div>
			
			<hr>
			<div class="checkbox">
				<label>
					<input name="mandatory" type="checkbox" value="1"<?php echo $item->mandatory == 1 ? ' checked="checked"' : '';?>> 
					<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MANDATORY_FIELD');?>
				</label>
			</div>
			<hr>
			
			<div class="form-group<?php echo $params->get('load_editor') ? '' : ' js-editor-tinymce';?>">
				<label for="description_<?php echo $item->id;?>"><?php echo JText::_('JGLOBAL_DESCRIPTION');?>:</label>
				<?php echo SurveyHelper::loadEditor($editor, 'description_'.$item->id, 'description', $item->description);?>
			</div>
		</div>
		<div role="tabpanel" class="tab-pane fade" id="answers-<?php echo $item->id?>">
			<div class="muted"><?php echo JText::_('COM_COMMUNITYSURVEYS_GRID_CORRECT_ANSWERS_HINT');?></div>
			<h4 class="page-header margin-top-10"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTIONS');?></h4>
			<div class="answers">
				<?php 
				foreach ($item->answers as $answer)
				{
					?>
					<div class="form-group answer">
						<input type="text" name="answer" value="<?php echo $this->escape($answer->title);?>" 
							placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_ANSWER');?>" class="input-xlarge no-margin-bottom required">
							
						<span class="answer-controls">
							<a href="#" onclick="return false;" class="btn-delete-answer" title="<?php echo JText::_('JACTION_DELETE');?>" data-toggle="tooltip">
								<i class="fa fa-trash-o"></i>
							</a>
						</span>
						<span class="answer-controls">
							<a href="#" onclick="return false;" class="btn-sort-answer" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT');?>" data-toggle="tooltip">
								<i class="fa fa-arrows"></i>
							</a>
						</span>
						<input type="hidden" name="aid" value="<?php echo $answer->id;?>">
					</div>
					<?php
				}
				?>
			</div>
			<button type="button" class="btn btn-primary btn-add-answer"><i class="fa fa-plus-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_ANSWER');?></button>
			
			<h4 class="page-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWERS');?></h4>
			<div class="columns">
				<?php 
				foreach ($item->columns as $answer)
				{
					?>
					<div class="form-group answer">
						<input type="text" name="answer" value="<?php echo $this->escape($answer->title);?>" 
							placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_ANSWER');?>" class="input-xlarge required">
						<span class="answer-controls">
							<a href="#" onclick="return false;" class="btn-delete-answer" title="<?php echo JText::_('JACTION_DELETE');?>" data-toggle="tooltip">
								<i class="fa fa-trash-o"></i>
							</a>
						</span>
						<span class="answer-controls">
							<a href="#" onclick="return false;" class="btn-sort-answer" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT');?>" data-toggle="tooltip">
								<i class="fa fa-arrows"></i>
							</a>
						</span>
						<input type="hidden" name="aid" value="<?php echo $answer->id;?>">
					</div>
					<?php
				}
				?>
			</div>
			<button type="button" class="btn btn-primary btn-add-column"><i class="fa fa-plus-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_ANSWER');?></button>
		</div>
		<div role="tabpanel" class="tab-pane fade" id="conditions-<?php echo $item->id?>">
			<table class="table table-hover table-condensed table-striped table-bordered rules-table">
				<thead>
					<tr>
						<th><?php echo JText::_('JGLOBAL_DESCRIPTION');?></th>
						<th width="20%"><?php echo JText::_('COM_COMMUNITYSURVEYS_ACTIONS');?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($item->rules as $rule):?>
					<tr>
						<td><?php echo $rule->description;?></td>
						<td>
							<a href="#" class="delete-rule" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_DELETE_RULE');?>" data-toggle="tooltip"
								onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.deleterule', 'onBeforeDeleteRule', 'onAfterDeleteRule'); return false;">
								<i class="fa fa-trash-o"></i> <?php echo JText::_('JACTION_DELETE');?>
							</a>
							<input type="hidden" name="item_rule_id" value="<?php echo $rule->id;?>">
						</td>
					</tr>
					<?php endforeach;?>
				</tbody>
			</table>
			
			<h3 class="page-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_ADD_NEW_RULE');?></h3>
			<div class="conditional-rules-form">
				<div class="rule-conditions">
					<label class="radio"><input type="radio" name="rule-name" value="1"> <?php echo JText::_('COM_COMMUNITYSURVEYS_RULE_IF_USER_ANSWER_THIS')?></label>
					<label class="radio"><input type="radio" name="rule-name" value="2"> <?php echo JText::_('COM_COMMUNITYSURVEYS_RULE_IF_USER_DO_NOT_ANSWER_THIS')?></label>
					<label class="radio"><input type="radio" name="rule-name" value="3"> <?php echo JText::_('COM_COMMUNITYSURVEYS_RULE_IF_USER_SELECT_AN_ANSWER')?></label>
					<label class="radio"><input type="radio" name="rule-name" value="4"> <?php echo JText::_('COM_COMMUNITYSURVEYS_RULE_IF_USER_DO_NOT_SELECT_AN_ANSWER')?></label>
				</div>
				<div class="rule-criteria form-horizontal margin-top-20 margin-bottom-10" style="display: none;">
            		<div class="control-group rule-answer" style="display: block;">
            			<label class="control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER')?></label>
            			<div class="controls">
            				<select name="rule-answer" size="1"></select>
            			</div>
            		</div>
            		<div class="control-group rule-column" style="display: block;">
            			<label class="control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_COLUMN')?></label>
            			<div class="controls">
            				<select name="rule-column" size="1"></select>
            			</div>
            		</div>
            		<div class="control-group">
            			<label class="control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_WHAT_DO_YOU_WANT_TO_DO')?></label>
            			<div class="controls">
            				<p><label class="radio"><input type="radio" name="rule-outcome" value="1"> <?php echo JText::_('COM_COMMUNITYSURVEYS_SKIP_TO_PAGE')?>:</label></p>
            				<p>
            					<select name="rule-page" size="1" class="margin-bottom-10">
            						<?php 
            						foreach($pages as $num=>$page)
            						{
            						    if($page->id != $item->page_number)
            						    {
                    						?>
                    						<option value="<?php echo $page->id;?>">
                    							<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $page->title, array('jsSafe'=>true)).' (ID: '.$page->id.')';?>
                    						</option>
                							<?php
            						    }
            						}
            						?>
            					</select>
            				</p>
            				<p class="rule-show-question" style="display: block;">
            					<label class="radio"><input type="radio" name="rule-outcome" value="3"> <?php echo JText::_('COM_COMMUNITYSURVEYS_SHOW_QUESTION_ON_THIS_PAGE')?></label>
            					<select name="rule-show-question" size="1" class="margin-bottom-10"></select>
            				</p>
            				<p><label class="radio"><input type="radio" name="rule-outcome" value="2"> <?php echo JText::_('COM_COMMUNITYSURVEYS_FINALIZE_RESPONSE');?></label></p>
            			</div>
            		</div>
            	</div>
            	<button type="button" class="btn btn-primary" 
            		onclick="CjSurveyApi.submitAjaxForm(this, '#qForm<?php echo $item->id?>', 'question.saverule', 'onBeforeSaveRule', 'onAfterSaveRule'); return false;">
					<i class="fa fa-plus-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SAVE_RULE');?>
				</button>
			</div>
		</div>
		
		<div role="tabpanel" class="tab-pane fade" id="customize-<?php echo $item->id?>">
			<div class="question-params form-horizontal">
    			<div class="form-group">
    				<label class="col-sm-3 control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTION_CSS_CLASS')?>: </label>
    				<div class="col-sm-9">
    					<input type="text" name="question_class" value="<?php echo $this->escape($item->params->get('question_class'));?>">
    				</div>
    			</div>
				<div class="form-group">
    				<label class="col-sm-3 control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_TITLE_CSS_CLASS')?>: </label>
    				<div class="col-sm-9">
    					<input type="text" name="title_class" value="<?php echo $this->escape($item->params->get('title_class'));?>">
    				</div>
    			</div>
				<div class="form-group">
    				<label class="col-sm-3 control-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_DESCRIPTION_CSS_CLASS')?>: </label>
    				<div class="col-sm-9">
    					<input type="text" name="description_class" value="<?php echo $this->escape($item->params->get('description_class'));?>">
    				</div>
    			</div>
			</div>
		</div>
	</div>
</div>
<div class="tpl-answer" style="display: none;">
	<div class="form-group answer">
		<input type="text" name="answer" value="" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_ANSWER');?>" class="input-xlarge no-margin-bottom required">
		<span class="answer-controls">
			<a href="#" onclick="return false;" class="btn-delete-answer" title="<?php echo JText::_('JACTION_DELETE');?>" data-toggle="tooltip">
				<i class="fa fa-trash-o"></i>
			</a>
		</span>
		<span class="answer-controls">
			<a href="#" onclick="return false;" class="btn-sort-answer" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_CLICK_DRAG_TO_SORT');?>" data-toggle="tooltip">
				<i class="fa fa-arrows"></i>
			</a>
		</span>
		<input type="hidden" name="aid" value="0">
	</div>
</div>