<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user 		= JFactory::getUser();
$data 		= $displayData['data'];
$pagination = $data->pagination;
$prevLimit	= $pagination->limitstart >= $pagination->limit ? $pagination->limitstart - $pagination->limit : 0;
$nextLimit	= $pagination->limitstart + $pagination->limit > $pagination->total ? $pagination->limitstart : $pagination->limitstart + $pagination->limit;
$limit		= $pagination->limit > $pagination->total ? $pagination->total : $pagination->limit;
?>
<div class="contacts-pagination">
	<div class="pull-right">
		<span class="label label-default"><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_NO', $pagination->pagesCurrent, $pagination->pagesTotal);?></span>
		<a href="#" class="btn btn-default btn-prev-contacts"
			onclick="document.inviteForm.limitstart.value=<?php echo $prevLimit;?>;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeGetPrevContacts', 'onAfterLoadContacts'); return false;">
			<?php echo JText::_('JPREVIOUS');?>
		</a>
		<a href="#" class="btn btn-default btn-next-contacts"
			onclick="document.inviteForm.limitstart.value=<?php echo $nextLimit;?>;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeGetNextContacts', 'onAfterLoadContacts'); return false;">
			<?php echo JText::_('JNEXT');?>
		</a>
	</div>
	<p><strong><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_SHOWING_CONTACTS_LIST_COUNT', $limit, $pagination->total);?></strong></p>
</div>
<table class="table table-hover table-condensed table-striped contacts-table">
	<thead>
		<tr>
			<th width="3%"><input type="checkbox" class="checkall"></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTACT_NAME');?></th>
			<th><?php echo JText::_('JGLOBAL_EMAIL');?></th>
			<th width="5%"><?php echo JText::_('JGRID_HEADING_ID');?></th>
		</tr>
	</thead>
	<tbody>
		<?php if(!empty($data->contacts)):?>
			<?php foreach ($data->contacts as $contact):?>			
			<tr>
				<td>
					<input type="checkbox" class="checkbox" name="jform[contact_id][]" value="<?php echo $contact->id?>">
				</td>
				<td>
					<?php echo $this->escape($contact->name);?>
				</td>
				<td>
					<?php echo $contact->email;?>
				</td>
				<td>
					<?php echo $contact->id;?>
				</td>
			</tr>
			<?php endforeach;?>
		<?php else:?>
		<tr>
			<td colspan="4"><?php echo JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH')?></td>
		</tr>
		<?php endif;?>
	</tbody>
</table>

<div class="actions">
	<input type="hidden" id="limit" name="limit" value="<?php echo $pagination->limit;?>">
	<input type="hidden" id="limitstart" name="limitstart" value="<?php echo $pagination->limitstart;?>">
	
	<div class="pull-right">
		<span class="label label-default"><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_NO', $pagination->pagesCurrent, $pagination->pagesTotal);?></span>
		<a href="#" class="btn btn-default btn-prev-contacts"
			onclick="document.inviteForm.limitstart.value=<?php echo $prevLimit;?>;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeGetPrevContacts', 'onAfterLoadContacts'); return false;">
			<?php echo JText::_('JPREVIOUS');?>
		</a>
		<a href="#" class="btn btn-default btn-next-contacts"
			onclick="document.inviteForm.limitstart.value=<?php echo $nextLimit;?>;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeGetNextContacts', 'onAfterLoadContacts'); return false;">
			<?php echo JText::_('JNEXT');?>
		</a>
	</div>
	<div class="action-buttons">
		<button id="btn-assign-contacts" type="button" class="btn btn-primary" data-toggle="modal" data-target="#assign-contacts-modal">
			<i class="fa fa-group"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ASSIGN_CONTACTS');?>
		</button>
		<button id="btn-unassign-contacts" type="button" class="btn btn-primary" data-toggle="modal" data-target="#assign-contacts-modal">
			<i class="fa fa-group"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_UNASSIGN_CONTACTS');?>
		</button>
		<button id="btn-add-contacts" type="button" class="btn btn-primary" data-toggle="modal" data-target="#contacts-form-modal">
			<i class="fa fa-plus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_CONTACTS');?>
		</button>
		<button id="btn-import-contacts" type="button" class="btn btn-primary" data-toggle="modal" data-target="#contacts-import-modal">
			<i class="fa fa-upload"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_IMPORT_CONTACTS');?>
		</button>
		<button id="btn-remove-contacts" type="button" class="btn btn-primary"
			onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.deletecontacts', 'onBeforeDeleteContacts', 'onAfterDeleteContacts'); return false;">
			<i class="fa fa-minus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_REMOVE_CONTACTS');?>
		</button>
	</div>
</div>