<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$stats				= array();

$stats[] = '[\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER').'\',\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES').'\']';
$item->votes = 0;

foreach ($item->answers as &$answer)
{
	$answer->votes = 0;
	foreach ($item->responses as $response)
	{
		if($answer->id == $response->answer_id)
		{
			$answer->votes = $answer->votes + $response->votes;
			$item->votes = $item->votes + $response->votes;
		}
	}
	$stats[] = '["'.$this->escape($answer->title).'",'.$answer->votes.']';
}
reset($item->answers);

$colors = array('#3366CC', '#DC3912', '#FF9900', '#109618', '#0099C6', '#DD4477', '#66AA00', '#AAAA11', '#994499', '#E67300');
$strColors = $params->get('chart_colors', '#3366CC,#DC3912,#FF9900,#109618,#0099C6,#DD4477,#66AA00,#AAAA11,#994499,#E67300');
if(!empty($strColors)) 
{
	$colors = explode(',', $strColors);
}
?>

<div class="panel-body">
	<div class="row">
		<div class="col-md-4">
			<div id="chart-<?php echo $item->id;?>" class="chartarea"></div>
			<script type="text/javascript">
				google.setOnLoadCallback(drawChart<?php echo $item->id;?>);
				function drawChart<?php echo $item->id;?>() 
				{
					var data = google.visualization.arrayToDataTable([<?php echo implode(',', $stats);?>]);
					var options = {'is3D': true, 'legend': 'none', 'width': '100%', chartArea:{left:20, top:0, width:'100%', height:'100%'}, 'colors': ['<?php echo implode('\',\'', $colors);?>'], pieHole: 0.4};
					var chart = new google.visualization.PieChart(document.getElementById('chart-<?php echo $item->id;?>'));
					chart.draw(data, options);
				}
			</script>
		</div>
		<div class="col-md-8">
			<?php
			foreach ($item->answers as $i=>&$answer)
			{
				$pct = $item->votes > 0 ? round( $answer->votes * 100 / $item->votes, 2) : 0;
				$color = $colors[$i % count($colors)]
				?>
				<label><?php echo $this->escape($answer->title) . ' <small>(' . $pct . '% / ' . JText::plural('COM_COMMUNITYSURVEYS_LABEL_VOTES', $answer->votes) . ')</small>';?></label>
				<div class="margin-left-5 pull-right label label-info vote-percent-box" style="background-color: <?php echo $color;?> !important; margin-left: 2px;"><?php echo $pct;?>%</div>
				<div class="progress">
					<div class="progress-bar progress-bar-info" style="width: <?php echo $pct;?>%; background-color: <?php echo $color;?> !important;">&nbsp;</div>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>


<?php 
if($params->get('show_text_answers', 1) == 1 && !empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ($item->textResponses as $response)
			{
			?>
			<tr>
				<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
				<td><?php echo $response->free_text;?></td>
			</tr>
			<?php
			}
			?>
			<tr>
				<td colspan="2">
					<a href="#" onclick="document.surveyForm.qid.value=<?php echo $item->id;?>; CjSurveyApi.submitAjaxForm(this, '#surveyForm', 'reports.getanswers', 'onBeforeGetTextAnswers', 'onAfterGetTextAnswers'); return false">
						<i class="fa fa-comments"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_ALL_RESPONSES');?>
					</a>
				</td>
			</tr>
		</tbody>
	</table>
	<?php
}
