<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::_('formbehavior.chosen', 'select');

$document	= JFactory::getDocument();
$data		= $displayData['data'];
$report		= $data->report;
$params 	= $data->params;

if($report && count($report) > 0)
{
	$document->addScript('https://www.google.com/jsapi');
	$document->addScriptDeclaration('google.load("visualization", "1", {packages:["geochart"]});');
	$document->addStyleSheet(CJLIB_MEDIA_URI.'/datatables/datatables.min.css');
	$document->addScript(CJLIB_MEDIA_URI.'/datatables/datatables.min.js');
	
	$stats = array();
	$stats[] = '[\''.JText::_('COM_COMMUNITYSURVEYS_CITY').'\',\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES').'\']';
	
	$countries = array();
	foreach ($report as $rep)
	{
		$countries[$rep['country_name']] = isset($countries[$rep['country_name']]) ? $countries[$rep['country_name']] + $rep['responses'] : $rep['responses']; 
	}
	
	foreach ($countries as $name=>$responses)
	{
		$stats[] = '["'.$this->escape($name).'",'.$responses.']';
	}
	?>
	<div class="location-report">
		<div class="map">
			<div id="geo-chart" style="width: 100%; height: 350px; margin-bottom: 20px;"></div>
			<script type="text/javascript">
				google.setOnLoadCallback(drawRegionsMap);
				function drawRegionsMap() 
				{
					var data = google.visualization.arrayToDataTable([<?php echo implode(',', $stats);?>]);
					var options = {};
					var chart = new google.visualization.GeoChart(document.getElementById('geo-chart'));
					chart.draw(data, options);
	
				    var table = jQuery('#locations-table').DataTable({
				    	dom: 'Bfrtip',
				    	buttons: ['copy', 'excel', 'pdf'],
				        columnDefs: [{ "visible": false, "targets": 0 }],
				        order: [[ 0, 'asc' ]],
				        displayLength: 25,
				        drawCallback: function ( settings ) {
				            var api = this.api();
				            var rows = api.rows( {page:'current'} ).nodes();
				            var last=null;
				 
				            api.column(0, {page:'current'} ).data().each( function ( group, i ) {
				                if ( last !== group ) {
				                    jQuery(rows).eq( i ).before(
				                        '<tr class="group"><td colspan="3" class="info">'+group+'</td></tr>'
				                    );
				 
				                    last = group;
				                }
				            } );
				        }
				    });
	
				    // Order by the grouping
				    jQuery('#locations-table tbody').on( 'click', 'tr.group', function () {
				        var currentOrder = table.order()[0];
				        if ( currentOrder[0] === 0 && currentOrder[1] === 'asc' ) {
				            table.order( [ 0, 'desc' ] ).draw();
				        }
				        else {
				            table.order( [ 0, 'asc' ] ).draw();
				        }
				    });
	
				    jQuery('.location-report select').addClass('input-mini input-xs').chosen();
				}
			</script>
		</div>
		<div class="table-responsive">
			<table class="table table-striped table-hover table-condensed" id="locations-table">
				<thead>
					<tr>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_COUNTRY');?></th>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_CITY');?></th>
						<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($report as $country):?>
					<tr>
						<td><strong><?php echo $this->escape($country['country_name']);;?></strong></td>
						<td><?php echo $this->escape($country['city']);?></td>
						<td><?php echo $country['responses'];?></td>
					</tr>
					<?php endforeach;?>
				</tbody>
			</table>
		</div>
	</div>
	<?php 
}
else 
{
	?>
	<p class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS');?></p>
	<?php
}
?>