<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$data		= $displayData['data'];
$params 	= $data->params;
$questions	= $data->questions;
$layout 	= $params->get('ui_layout', 'default');

if(JFactory::getApplication()->isAdmin() && !$data->print)
{
    ?>
    <div class="panel panel-default">
    	<div class="panel-heading"><h4 class="panel-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_COMMENTS');?></h4></div>
    	<div class="panel-body comments-wrap">
    		<div class="comment"><?php echo $data->comment;?></div>
    		<small class="text-muted">
				<a href="#" onclick="return false;" class="btn-add-comment text-error" data-rid="<?php echo $data->rid;?>">
					<?php echo empty($data->comment) ? JText::_('COM_COMMUNITYSURVEYS_ADD_COMMENT') : JText::_('COM_COMMUNITYSURVEYS_EDIT_COMMENT');?>
				</a>
			</small>
    	</div>
    </div>
    <?php
}

foreach ($questions as $question)
{
    $question->rid = $data->rid;
	echo SurveyHelper::renderLayout($layout.'.results.question', array('item'=>$question, 'params'=>$params));
}
?>
