<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$answers    = $displayData['answers'];
$params 	= $displayData['params'];
?>
<div class="table-responsive" style="max-height: 400px;">
	<table class="table table-condensed table-hover table-striped text-answers">
		<thead>
			<tr>
				<th><?php echo JText::_('ID');?></th>
				<th width="20%" style="min-width: 15%;"><?php echo JText::_('JDATE');?></th>
				<th width="20%" style="min-width: 15%;"><?php echo JText::_('JAUTHOR');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_TEXT_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
	    <?php
	    if(!empty($answers))
	    {
			foreach ($answers as $answer)
			{
				?>
				<tr class="list-group no-margin-left">
					<td><?php echo $answer->response_id?></td>
					<td><?php echo $answer->created?></td>
					<td><?php echo $answer->created_by > 0 ? $this->escape($answer->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
					<td>
						<?php
						switch ($answer->question_type)
						{
							case CS_SPECIAL_NAME:
								$parts = explode('|', $answer->free_text);
								echo $this->escape($parts[0]).'. '.$this->escape($parts[1]).' '.$this->escape($parts[2]);
								break;
								
							case CS_SPECIAL_EMAIL:
								?><a href="mailto:<?php echo $this->escape($answer->free_text);?>" target="_top"><?php echo $this->escape($answer->free_text);?></a><?php
								break;
								
							case CS_SPECIAL_CALENDAR:
								echo JHtml::date($answer->free_text , 'D F n, Y g:i a');
								break;
								
							case CS_SPECIAL_ADDRESS:
								$parts = explode('|||', $answer->free_text);
								?>
								<address class="no-margin-bottom">
									<strong><?php echo $this->escape($parts[0]);?></strong><br>
									<?php echo $this->escape($parts[1]);?>, <?php echo $this->escape($parts[2]);?><br>
									<?php echo $this->escape($parts[3]);?>, <?php echo $this->escape($parts[4]);?><br>
									<?php echo $this->escape($parts[5]);?>, <?php echo $this->escape($parts[6]);?>
								</address>
								<?php
								break;
								
							default:
								echo $this->escape($answer->free_text);
							break;
						}
						?>
					</td>
				</tr>
				<?php
			}
	    }
	    ?>
	    </tbody>
	</table>
</div>