<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$data		= $displayData['data'];
$item 		= $displayData['question'];
$state		= isset($data->state) ? $data->state : null;
$params 	= $data->params;
$theme 		= $params->get('theme', 'default');
$layout 	= $params->get('ui_layout');

$layouts = array(
    CS_PAGE_HEADER => 'page_header',
    CS_CHOICE_RADIO => 'radio',
    CS_CHOICE_CHECKBOX => 'checkbox',
    CS_CHOICE_SELECT => 'select',
    CS_CHOICE_NPS => 'nps',
    CS_CHOICE_MULTIRATING => 'multirating',
    CS_CHOICE_RANKING => 'ranking',
    CS_CHOICE_SLIDER => 'slider',
    CS_GRID_RADIO => 'radio_grid',
    CS_GRID_CHECKBOX => 'checkbox_grid',
    CS_FREE_TEXT_SINGLE_LINE => 'textbox',
    CS_FREE_TEXT_MULTILINE => 'textarea',
    CS_FREE_TEXT_PASSWORD => 'password',
    CS_FREE_TEXT_RICH_TEXT => 'rich_textbox',
    CS_IMAGE_CHOOSE_IMAGE => 'image_radio',
    CS_IMAGE_CHOOSE_IMAGES => 'image_checkbox',
    CS_GRID_MATCHING => 'matching',
    CS_FILE_UPLOAD => 'fileupload',
    CS_SPECIAL_NAME => 'name',
    CS_SPECIAL_EMAIL => 'email',
    CS_SPECIAL_CALENDAR => 'calendar',
    CS_SPECIAL_ADDRESS => 'address',
    CS_SPECIAL_SIGNATURE => 'signature'
);
?>
<div 
	class="panel panel-<?php echo $theme;?> question-item qtype-<?php echo $layouts[$item->question_type];?> <?php echo ($item->hidden ? ' hideme' : '') . ($item->mandatory ? ' mandatory' : '') . $this->escape($item->params->get('question_class'));?> <?php echo $layout;?>"
	id="question-<?php echo $item->id?>"
	<?php echo !empty($item->rule_answered) ? ' showitems="'.implode(',', $item->rule_answered).'"' : '';?>>

	<div class="panel-heading question-header">
		<div class="panel-title <?php echo $this->escape($item->params->get('title_class'));?>"><i class="fa fa-caret-right"></i> <?php echo $item->title;?></div>
	</div>
	
	<?php 
	$description = $item->description;
	if(!empty($description))
	{
		?>
		<div class="panel-body">
			<div class="<?php echo $this->escape($item->params->get('description_class'));?>">
				<?php 
				JPluginHelper::importPlugin('content');
				$item->text = $item->description;
				JFactory::getApplication()->triggerEvent('onContentPrepare', array('com_communitysurveys.response',	&$item,	&$params, 0));
				$item->description = $item->text;
				
				echo $item->description;
				?>
			</div>
		</div>
		<?php
	}
	
	echo $this->sublayout($layouts[$item->question_type], array('item'=>$item, 'params'=>$params, 'state'=>$state));
	?>
	
	<input name="qid[]" value="<?php echo $item->id?>" type="hidden">
</div>