<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php 
		foreach ($item->responses as $response)
		{
			if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
				break;
			}
		}
		
		$address_parts = explode('|||', $free_text);
		if(count($address_parts) != 7)
		{
			$address_parts = array('', '', '', '', '', '', '');
		}
		?>
		<div class="address-wrapper">
			<div class="row">
				<div class="col-md-12">
					<input type="text" name="address-name-<?php echo $item->id;?>" class="<?php echo $required;?>" 
						value="<?php echo $address_parts[0];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_FULL_NAME');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_FULL_NAME');?>">
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<input type="text" name="address-line1-<?php echo $item->id;?>" class="<?php echo $required;?>" 
						value="<?php echo $address_parts[1];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_LINE1');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_LINE1');?>">
				</div> 
			</div>
			<div class="row">
				<div class="col-md-7">
					<input type="text" name="address-line2-<?php echo $item->id;?>" class="" 
						value="<?php echo $address_parts[2];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_LINE2');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_LINE2');?>">
				</div>
				<div class="col-md-5">
					<input type="text" name="address-city-<?php echo $item->id;?>" class="<?php echo $required;?>" 
						value="<?php echo $address_parts[3];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_CITY');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_CITY');?>">
				</div>
			</div>
			<div class="row">
				<div class="col-md-4">
					<input type="text" name="address-state-<?php echo $item->id;?>" class="<?php echo $required;?>" 
						value="<?php echo $address_parts[4];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_STATE');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_STATE');?>">
				</div>
				<div class="col-md-5">
					<?php echo SurveyHelper::getCountriesList('address-country-'.$item->id, $address_parts[5]);?>
				</div>
				<div class="col-md-3">
					<input type="text" name="address-zip-<?php echo $item->id;?>" class="<?php echo $required;?>" 
						value="<?php echo $address_parts[6];?>" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_ZIP');?>"
						aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ADDRESS_STATE');?>">
				</div>
			</div>
		</div>
	</li>
</ul>