<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<div class="panel-body">
	<div class="answers clearfix" role="radiogroup" aria-label="<?php echo $this->escape(strip_tags($item->title));?>">
		<div class="row">
			<?php 
			foreach ($item->answers as $i=>$answer)
			{
				$checked = false;
				$rules = '';
				foreach ($item->responses as $response)
				{
					if($answer->id == $response->answer_id)
					{
						$checked = true;
					} 
					else if(!empty($response->free_text))
					{
						$free_text = CjLibUtils::escape($response->free_text);
					}
				}
				
				if(isset($item->rule_selected[$answer->id]))
				{
					$rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id]).'"';
				}
				
				if($item->orientation != 'IL')
				{
					?>
					<div class="margin-bottom-20">
						<div class="form-check">
            				<label class="form-check-label" for="answer-<?php echo $answer->id;?>">
            					<input type="radio" 
            						name="answer-<?php echo $item->id;?>"
            						id="answer-<?php echo $answer->id;?>" 
            						value="<?php echo $answer->id?>"<?php echo $checked ? ' checked="checked"' : '';?> 
            						class="form-check-input <?php echo $required;?> mgr mgr-primary"
            						<?php echo $rules;?>
            						role="radio"
            						aria-checked="<?php echo $checked ? 'true' : 'false';?>"
            						tabindex="<?php echo $i ? '-1' : '0';?>"> <?php echo $this->escape($answer->title);?>
            				</label>
            			</div>
						<img src="<?php echo CS_IMAGES_URI.$answer->image?>" alt="<?php echo $this->escape($answer->title);?>">
					</div>
					<?php 
				} 
				else 
				{
					?>
					<div class="col-md-2 margin-bottom-20">
						<div class="thumbnail text-center">
							<img src="<?php echo CS_IMAGES_URI.$answer->image;?>" alt="<?php echo $this->escape($answer->title);?>">
							<div class="form-check">
                				<label class="form-check-label" for="answer-<?php echo $answer->id;?>">
                					<input type="radio" 
                						name="answer-<?php echo $item->id;?>"
                						id="answer-<?php echo $answer->id;?>" 
                						value="<?php echo $answer->id?>"<?php echo $checked ? ' checked="checked"' : '';?> 
                						class="form-check-input <?php echo $required;?> mgr mgr-primary"
                						<?php echo $rules;?>
                						role="radio"
                						aria-checked="<?php echo $checked ? 'true' : 'false';?>"
                						tabindex="<?php echo $i ? '-1' : '0';?>"> <?php echo $this->escape($answer->title);?>
                				</label>
                			</div>
						</div>
					</div>
					<?php 
				}
			}
			?>
		</div>
	</div>
	<div class="row">
		<?php 
		if($item->custom_choice == 1)
		{
			?>
			<input type="text" name="free-text-<?php echo $item->id;?>" class="input-xlarge" 
				value="<?php echo $free_text;?>"  placeholder="<?php echo $customAnswerPH;?>" aria-label="<?php echo $customAnswerPH;?>">
			<?php 
		}
		?>
	</div>
</div>
