<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
?>
<div class="table-responsive">
	<table class="table table-hover table-bordered table-striped margin-bottom-20">
		<thead>
			<tr>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTION');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?></th>
			</tr>
		<thead>
		<tbody>
			<?php
			foreach($item->answers as $answer)
			{
			    ?>
			    <tr>
                    <td><?php echo $this->escape($answer->title);?></td>
                    <td>
                        <?php 
                        if(!empty($item->responses))
                        {
                        	foreach($item->columns as $column)
                        	{
                        		foreach ($item->responses as $response)
                        		{
                        			if($response->answer_id == $answer->id && $response->column_id == $column->id)
                        			{
                        				echo $this->escape($column->title);
                        				break;
                        			}
                        		}
                        	}
                        }
                        ?>
                    </td>
			    </tr>
			    <?php
			}
			?>
		</tbody>
	</table>
</div>