<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user = JFactory::getUser();

$params 			= $displayData['params'];
$state				= isset($displayData['state']) ? $displayData['state'] : null;
$pagination 		= $displayData['pagination'];
$items 				= $displayData['items'];
$theme 				= $params->get('theme', 'default');
$avatar  			= $params->get('avatar_component', 'none');
$profileComponent 	= $params->get('profile_component', 'none');
$avatarSize 		= $params->get('list_avatar_size', 48);
$heading 			= isset($displayData['heading']) ? $displayData['heading'] : JText::_('COM_COMMUNITYSURVEYS_SURVEYS');
$subHeading 		= '';

$category = isset($displayData['category']) ? $displayData['category'] : null;
$subHeading = $category ? ' <small>['.$this->escape($category->title).']</small>' : $subHeading;

if(is_object($state))
{
	$authorId = $state->get('filter.author_id', 0);
	if($authorId)
	{
		$author = JFactory::getUser($authorId);
		$subHeading = $subHeading.' <small>['.$author->name.']</small>';
	}
	
	$ordering = $state->get('list.ordering', '');
	if($ordering == 'a.responses')
	{
		$subHeading = $subHeading.' <small>['.JText::_('COM_COMMUNITYSURVEYS_LABEL_POPULAR_SURVEYS').']</small>';
	}
	
	$recent = $state->get('list.recent', false);
	if($recent == true)
	{
		$subHeading = $subHeading.' <small>['.JText::_('COM_COMMUNITYSURVEYS_LABEL_RECENT_SURVEYS').']</small>';
	}
}

if(!empty($items))
{
    $api = new CjLibApi();
    $return = base64_encode(JUri::current());
    ?>
    
    <div class="panel panel-<?php echo $theme;?>">
    
    	<?php if(!empty($heading)):?>
    	<div class="panel-heading">
    		<div class="panel-title"><i class="fa fa-comments"></i> <?php echo $heading.$subHeading;?></div>
    	</div>
    	<?php endif;?>
    	
    	<ul class="list-group no-margin-left">
    	<?php 
    	foreach ($items as $item)
    	{
    		$author 		= $this->escape($item->author);
    		$profileUrl 	= $api->getUserProfileUrl($profileComponent, $item->created_by);
    		$surveyUrl 		= CommunitySurveysHelperRoute::getSurveyRoute($item->slug, $item->catslug, $item->language);
    		$userAvatar 	= $api->getUserAvatarImage($avatar, $item->created_by, $item->author_email, $avatarSize, true);
    		?>
    		<li class="list-group-item pad-bottom-5">
    			<div class="media">
    				<?php
    				///////////////////////////////// AVATAR ////////////////////////////////
    				if($avatar != 'none' && $params->get('list_show_avatar', 1) == 1)
    				{
    					?>
    					<div class="media-left hidden-xs">
    						<div class="media-object">
    							<?php if($profileComponent != 'none'):?>
    							<a href="<?php echo $profileUrl;?>" title="<?php echo $author?>" class="thumbnail no-margin-bottom" data-toggle="tooltip">
    								<img src="<?php echo $userAvatar;?>" alt="<?php echo $author?>" style="max-width: <?php echo $avatarSize;?>px" class="media-object">
    							</a>
    							<?php else:?>
    							<div class="thumbnail no-margin-bottom">
    								<img src="<?php echo $userAvatar;?>" alt="<?php echo $author?>" style="max-width: <?php echo $avatarSize;?>px">
    							</div>
    							<?php endif;?>
    						</div>
    					</div>
    					<?php 
    				}
    				///////////////////////////////// AVATAR ////////////////////////////////
    				///////////////////////////// RESPONSES BOX /////////////////////////////
    				if($params->get('list_show_hits', 1) == 1)
    				{
	    				?>
	    				<div class="media-left hidden-xs no-margin-bottom">
	    					<div class="panel panel-<?php echo $theme;?> item-count-box">
	    						<div class="panel-body text-center item-count-num"><?php echo CjLibUtils::formatNumber($item->responses);?></div>
	    						<div class="panel-footer text-nowrap text-muted item-count-caption">
	    							<?php echo JText::plural('COM_COMMUNITYSURVEYS_RESPONSES', $item->responses);?>
	    						</div>
	    					</div>
	    				</div>
	    				<?php
    				}
    				///////////////////////////// RESPONSES BOX /////////////////////////////
    				?>
    				
    				<div class="media-body">
        				<?php 
        				///////////////////////////// TITLE /////////////////////////////
        				?>
    					<h4 class="media-heading no-margin-top">
    						<?php
    						if ($item->private != 1 && $item->state == 1 && in_array($item->access, $user->getAuthorisedViewLevels()))
    						{
    							?>
    							<a href="<?php echo JRoute::_($surveyUrl); ?>" rel="nofollow">
    								<?php echo $this->escape($item->title); ?>
    							</a>
    							<?php
    						}
    						else 
    						{
    							echo $this->escape($item->title);
    							if($user->guest)
    							{
        							$itemId = JFactory::getApplication()->getMenu()->getActive()->id;
        							$fullURL = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId.'&return='.base64_encode(JRoute::_($surveyUrl)));
        							?>
        							<a href="<?php echo $fullURL; ?>" class="register" rel="nofollow">
        								: <?php echo JText::_('COM_COMMUNITYSURVEYS_REGISTER_TO_TAKE_SURVEY'); ?>
        							</a>
        							<?php
    							}
    						}
    						?>
    					</h4>
    					<?php 
    					///////////////////////////// TITLE /////////////////////////////
    					
    					///////////////////////// ACTION BUTTONS ////////////////////////
    					if($item->params->get('access-edit') || $user->authorise('core.manage', 'com_communitysurveys'))
    					{
    						?>
    						<div class="actions">
    							<?php if($item->params->get('access-edit')):?>
    							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($item->id).'&return='.$return);?>" class="text-error margin-right-10">
                                    <i class="fa fa-edit"></i> <?php echo JText::_('JGLOBAL_EDIT');?>
    							</a>
    							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($item->id).'&layout=questions&return='.$return);?>" class="text-error margin-right-10">
                                    <i class="fa fa-edit"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_EDIT_QUESTIONS');?>
    							</a>
    							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getInviteRoute($item->id).'&return='.$return);?>" class="text-error margin-right-10">
                                    <i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE');?>
    							</a>
    							<?php endif;?>
    							
    							<?php if($item->params->get('access-edit') || $user->authorise('core.manage', 'com_communitysurveys')):?>
    							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getReportsRoute($item->id).'&return='.$return);?>" class="text-error">
                                    <i class="fa fa-globe"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_REPORTS');?>
    							</a>
    							<?php endif;?>
    						</div>
    						<?php 
    					}
    					///////////////////////// ACTION BUTTONS ////////////////////////
    					?>
    					
    					<?php 
    					/////////////////////////// INFORMATION //////////////////////////
    					?>
    					<ul class="inline list-inline forum-info text-muted">
    						<?php if($item->state == 0 || $item->state == -2 || $item->state == 3 || $item->private == 1):?>
    						<li>
    							<?php if($item->state == 0):?>
    							<span class="label label-warning"><i class="fa fa-ban"></i> <?php echo JText::_('JUNPUBLISHED');?></span>
    							<?php endif;?>
    							
    							<?php if($item->state == -2):?>
    							<span class="label label-danger"><i class="fa fa-trash-o"></i> <?php echo JText::_('JTRASHED');?></span>
    							<?php endif;?>
    							
    							<?php if($item->state == 3):?>
    							<span class="label label-warning"><i class="fa fa-spinner fa-pulse"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_UNDER_CONSTRUCTION');?></span>
    							<?php endif;?>
    							
    							<?php if($item->private == 1):?>
    							<span class="label label-success"><i class="fa fa-user-secret"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PRIVATE');?></span>
    							<?php endif;?>
    						</li>
    						<?php endif;?>
    						
    						<?php if($params->get('list_show_author', 1) == 1):?>
    						<li class="muted">
    							<?php 
    							if($profileComponent != 'none')
    							{
    								$profileLink = JHtml::link($profileUrl, $item->author);
    								echo JText::sprintf('COM_COMMUNITYSURVEYS_POSTED_BY', $profileLink);
    							}
    							else
    							{
    								echo JText::sprintf('COM_COMMUNITYSURVEYS_POSTED_BY', $author);
    							}
    							?>
    						</li>
    						<?php endif;?>
    						
    						<?php if($params->get('list_show_parent', 1) == 1):?>
    						<li>
    							<?php 
    							$catLink = JHtml::link(CommunitySurveysHelperRoute::getCategoryRoute($item->catid, $item->language), $item->category_title);
    							echo JText::sprintf('COM_COMMUNITYSURVEYS_CATEGORY_IN', $catLink);?>
    						</li>
    						<?php endif;?>
    						
    						<?php if(isset($item->displayDate) && $params->get('list_show_date', 1) == 1):?>
    						<li>
    							<?php echo CjLibDateUtils::getHumanReadableDate($item->displayDate);?>.
    						</li>
    						<?php endif;?>
    						
    						<?php if($params->get('list_show_hits', 1) == 1):?>
    						<li class="visible-xs">
    							<?php echo JText::plural('COM_COMMUNITYSURVEYS_NUM_RESPONSES_TEXT', $item->responses);?>
    						</li>
    						<?php endif;?>
    					</ul>
    					
    					<?php if($params->get('list_show_description', 1) == 1): ?>
    					<div class="margin-top-5 description">
    						<?php echo JHtml::_('string.truncate', strip_tags($item->description), $params->get('readmore_limit', 180));?>
    					</div>
    					<?php endif;?>
    
    					<?php 
    					///////////////////////////// TAGS //////////////////////////////
    					if ($params->get('show_tags', 1) && !empty($item->tags))
    					{
        					?>
        					<div class="margin-top-5 tags">
        						<?php 
        						$item->tagLayout = new JLayoutFile('joomla.content.tags');
        						echo $item->tagLayout->render($item->tags->itemTags);
        						?>
        					</div>
        					<?php
    					}
    					///////////////////////////// TAGS //////////////////////////////
    					?>
    				</div>
    			</div>
    		</li>
    		<?php
    	}
    	?>
    	</ul>
    </div>
    
    <?php
    echo CJFunctions::load_module_position('surveys-list-above-pagination');
    
    if (($params->def('show_pagination', 2) == 1  || ($params->get('show_pagination') == 2)) && ($pagination->pagesTotal > 1)) 
    {
        ?>
		<form action="<?php echo htmlspecialchars(JUri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm">
			<div class="pagination">
				<?php if ($params->def('show_pagination_results', 1)) : ?>
					<p class="counter pull-right">
						<?php echo $pagination->getPagesCounter(); ?>
					</p>
				<?php endif; ?>
		
				<?php echo $pagination->getPagesLinks(); ?>
			</div>
		</form>
		<?php 
    }
}
else if($params->get('show_no_surveys'))
{
	?>
	<div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_NO_SURVEYS')?></div>
	<?php 
}
?>