<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$heading    = $displayData['heading'];

$theme      = $params->get('theme');
?>
<?php if ($params->get('show_page_heading', 1)) : ?>
<h1 class="page-header no-space-top"> <?php echo $this->escape($heading); ?> </h1>
<?php endif; ?>

<div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_SEARCH_CRITERIA');?></div>

<form action="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute());?>" method="get">
	
	<div class="card bg-<?php echo $theme;?> mb-3">
		<div class="card-header">
			<div class="card-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_KEYWORDS');?></div>
		</div>
		<div class="card-body">
			<div class="form-row align-items-center mb-2">
				<div class="col-auto">
    		 		<input name="list_filter" type="text" class="form-control" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_KEYWORDS');?>">
    		 	</div>
    		 	<div class="col-auto">
        		 	<select name="list_filter_field" class="form-control">
        		 		<option value="title"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_TITLES');?></option>
        		 		<option value="author"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_USER_NAME');?></option>
        		 		<option value="createdby"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_USERID');?></option>
        		 		<option value="id"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_SURVEY_ID');?></option>
        		 	</select>
        		 </div>
    		 </div>
    		 <div class="form-check">
    		 	<input type="checkbox" value="1" name="filter_all_keywords" id="filter_all_keywords" class="form-check-input">
    		 	<label class="form-check-label" for="filter_all_keywords"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ALL_WORDS');?></label>
    		 </div>
		</div>
	</div>
	<div class="card-deck mb-3">
		<div class="card bg-<?php echo $theme;?>">
			<div class="card-header">
				<div class="card-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_OPTIONS');?></div>
			</div>
			<div class="card-body">
				<div class="form-group row">
					<label for="filter_order" class="col-sm-4 col-form-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ORDER_BY');?></label>
					<div class="col-sm-8">
    					<select name="filter_order" id="filter_order" size="1" class="form-control">
        					<option value="a.created"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_DATE');?></option>
        					<option value="a.responses"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?></option>
        					<option value="a.catid"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CATEGORY');?></option>
        				</select>
        			</div>
        		</div>
				<div class="form-group row">
					<label for="filter_order_Dir" class="col-sm-4 col-form-label"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ORDER');?></label>
					<div class="col-sm-8">
        				<select name="filter_order_Dir" id="filter_order_Dir" size="1" class="form-control">
        					<option value="asc"><?php echo JText::_('COM_COMMUNITYSURVEYS_ASCENDING');?></option>
        					<option value="desc"><?php echo JText::_('COM_COMMUNITYSURVEYS_DESCENDING');?></option>
        				</select>
        			</div>
        		</div>
			</div>
		</div>
		<div class="card bg-<?php echo $theme;?>">
			<div class="card-header">
				<div class="card-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CATEGORIES');?></div>
			</div>
			<div class="card-body">
				<?php 
				$categories = JHtml::_('category.categories', 'com_communitysurveys');
				foreach ($categories as $id=>$category)
				{
					if($category->value == '1') 
					{
						unset($categories[$id]);
					}
				}
				
				$nocat = new JObject();
				$nocat->set('text', JText::_('COM_COMMUNITYSURVEYS_LABEL_ALL_CATEGORIES'));
				$nocat->set('value', '0');
				$nocat->set('disable', false);
				
				array_unshift($categories, $nocat);
				echo JHTML::_('select.genericlist', $categories, 'catid[]', 'size = "6" multiple="multiple" class="form-control"');
				?>
			</div>
		</div>
	</div>
	<div class="card bg-<?php echo $theme;?> mb-3">
		<div class="card-body text-center">
			<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute())?>" class="btn btn-default"><?php echo JText::_('JCANCEL');?></a>
			<button class="btn btn-primary" type="submit"><i class="fa fa-search-plus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SEARCH');?></button>
		</div>
	</div>
	
	<input type="hidden" name="view" value="surveys">
	<input type="hidden" id="filter_featured" name="filter_featured" value="">
</form>