<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user 				= JFactory::getUser();
$data				= $displayData['data'];
$item				= $data->item;
$params				= $data->params;

$theme 				= $params->get('theme', 'default');
$avatar  			= $params->get('avatar_component', 'none');
$profileComponent 	= $params->get('profile_component', 'none');
$avatarSize 		= $params->get('list_avatar_size', 48);
$layout				= $params->get('ui_layout', 'default');
?>

<h2 class="page-heading"><?php echo $this->escape($item->title);?></h2>

<form id="inviteForm" name="inviteForm" class="form-vertical" method="post"
	action="<?php echo JRoute::_(CommunitySurveysHelperRoute::getInviteRoute($item->id, $item->language));?>">
	<div class="accordion" id="invitations" role="tablist" aria-multiselectable="true">
	
		<?php //////////////////////////////// BASIC DETAILS /////////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="basicDetailsHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkBasicDetails" aria-expanded="true" aria-controls="blkBasicDetails">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_BASIC_DETAILS');?>
					</a>
				</h4>
			</div>
			<div id="blkBasicDetails" class="panel-collapse collapse" data-parent="#invitations" role="tabpanel" aria-labelledby="basicDetailsHeading">
				<div class="card-body">
					<?php echo $data->form->renderField('title');?>
					<?php echo $data->form->renderField('description');?>
				</div>
			</div>
		</div>
		<?php ////////////////////////////// END BASIC DETAILS ///////////////////////////////////////?>
		
		<?php ///////////////////////////////// CONTACT GROUPS ///////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="contactGroupsHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkContactGroups" aria-expanded="true" aria-controls="blkContactGroups">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_YOUR_CONTACT_GROUPS');?>
					</a>
				</h4>
			</div>
			<div id="blkContactGroups" class="panel-collapse collapse" data-parent="#invitations" role="tabpanel" aria-labelledby="contactGroupsHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.contactgroups', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php /////////////////////////////// END CONTACT GROUPS //////////////////////////////////////?>
		
		<?php if($user->authorise('core.manage', 'com_communitysurveys.survey.'.$item->id)):?>
		<?php /////////////////////////////// REGISTERED USERS ////////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="registeredUsersHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkRegisteredUsers" aria-expanded="true" aria-controls="blkRegisteredUsers">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_REGISTERED_USERS');?>
					</a>
				</h4>
			</div>
			<div id="blkRegisteredUsers" class="panel-collapse collapse" data-parent="#invitations" role="tabpanel" aria-labelledby="registeredUsersHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.registeredusers', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php /////////////////////////////// END REGISTERED USERS ////////////////////////////////////?>
		
		<?php ////////////////////////////// REGISTERED USER GROUPS ///////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="userGroupsHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkUserGroups" aria-expanded="true" aria-controls="blkUserGroups">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_REGISTERED_USER_GROUPS');?>
					</a>
				</h4>
			</div>
			<div id="blkUserGroups" class="panel-collapse collapse" data-parent="#invitations" role="tabpanel" aria-labelledby="userGroupsHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.usergroups', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php endif;?>
		<?php //////////////////////////// END REGISTERED USER GROUPS /////////////////////////////////?>
		
		<?php ///////////////////////////////// COMMUNITY GROUPS //////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="communityGroupsHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkCommunityGroups" aria-expanded="true" aria-controls="blkCommunityGroups">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_COMMUNITY_USER_GROUPS');?>
					</a>
				</h4>
			</div>
			<div id="blkCommunityGroups" class="panel-collapse collapse" data-parent="#invitations" role="tabpanel" aria-labelledby="communityGroupsHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.communitygroups', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php /////////////////////////////// END COMMUNITY GROUPS ////////////////////////////////////?>
	</div>
	
	<h2 class="page-heading"><?php echo JText::_('COM_COMMUNITYSURVEYS_OTHER_INVITATION_OPTIONS');?></h2>
	<div class="accordion" id="other-invitations" role="tablist" aria-multiselectable="true">
		
		<?php ///////////////////////////////// GLOBAL SURVEY URL /////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="globalSurveyUrlHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkGlobalSurveyUrl" aria-expanded="true" aria-controls="blkGlobalSurveyUrl">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_GLOBAL_SURVEY_URL');?>
					</a>
				</h4>
			</div>
			<div id="blkGlobalSurveyUrl" class="panel-collapse collapse" data-parent="#other-invitations" role="tabpanel" aria-labelledby="globalSurveyUrlHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.globalurl', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php /////////////////////////////// END GLOBAL SURVEY URL ///////////////////////////////////?>
		
		<?php ///////////////////////////////// CREATE SURVEY URLS ////////////////////////////////////?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="uniqueSurveyUrlsHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkUniqueSurveyUrls" aria-expanded="true" aria-controls="blkUniqueSurveyUrls">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_CREATE_SURVEY_URLS');?>
					</a>
				</h4>
			</div>
			<div id="blkUniqueSurveyUrls" class="panel-collapse collapse" data-parent="#other-invitations" role="tabpanel" aria-labelledby="uniqueSurveyUrlsHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.uniqueurls', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php /////////////////////////////// END CREATE SURVEY URLS //////////////////////////////////?>
		
		<?php ///////////////////////////////////// ACYMAILING ////////////////////////////////////////?>
		<?php if($user->authorise('core.manage', 'com_communitysurveys.survey.'.$item->id)):?>
		<div class="card bg-<?php echo $theme;?> mb-1">
			<div class="card-header" role="tab" id="acyMailingHeading">
				<h4 class="card-title">
					<a role="button" data-toggle="collapse" href="#blkAcyMailing" aria-expanded="true" aria-controls="blkAcyMailing">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_THROUGH_ACYMAILING');?>
					</a>
				</h4>
			</div>
			<div id="blkAcyMailing" class="panel-collapse collapse" data-parent="#other-invitations" role="tabpanel" aria-labelledby="acyMailingHeading">
				<div class="card-body">
					<?php echo SurveyHelper::renderLayout($layout.'.invite.acymailing', array('data'=>$data));?>
				</div>
			</div>
		</div>
		<?php endif;?>
		<?php /////////////////////////////////// END ACYMAILING //////////////////////////////////////?>
	</div>
	
	<input type="hidden" name="task" value="">
	<input type="hidden" name="cid" value="0">
	<input type="hidden" name="jform[assignAction]" id="assignAction" value="1">
</form>
	
<form id="import_contacts_form" action="<?php echo JRoute::_('index.php?option=com_communitysurveys');?>" 
	enctype="multipart/form-data" method="post" style="position:absolute; top:-1000px;">
	<input type="file" name="csvfile" id="csvfile">
	<input type="hidden" name="view" value="invite">
	<input type="hidden" name="task" value="invite.importcontacts">
</form>

<div style="display: none">
	<input type="hidden" name="cjpageid" id="cjpageid" value="invite">
	<span id="msg_select_required_items"><?php echo JText::_('COM_COMMUNITYSURVEYS_PLEASE_SELECT_REQUIRED_ITEMS');?></span>
	<span id="msg_missing_required_fields"><?php echo JText::_('COM_COMMUNITYSURVEYS_REQUIRED_FIELDS_MISSING');?></span>
	<span id="msg_confirm_action"><?php echo JText::_('COM_COMMUNITYSURVEYS_CONFIRM_ACTION');?></span>
</div>