<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user = JFactory::getUser();
$data				= $displayData['data'];
$item				= $data->item;
$params				= $data->params;
$layout				= $params->get('ui_layout', 'default');
?>
<div class="registered-users-wrapper">
	<div class="registered-users-intro"><?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_REGISTERED_USERS_INTRO');?></div>
	<div class="users-selector">
		<div class="filterbox">
			<input type="text" name="filter_username" value="" class="form-control" placeholder="<?php echo JText::_('JSEARCH_FILTER');?>">
		</div>
		<div class="user-selector-box clearfix">
			<div class="us-box us-left">
				<ul class="list-inline">
					<li><a href="#" onclick="return false;" class="text-muted small btn-select-all-users"><?php echo JText::_('JGLOBAL_SELECTION_ALL')?></a></li>
					<li><a href="#" onclick="return false;" class="text-muted small btn-deselect-all-users"><?php echo JText::_('JGLOBAL_SELECTION_NONE')?></a></li>
				</ul>
				<div class="list-group users-list users-available"></div>
			</div>
			<div class="us-box us-middle">
				<div class="us-buttons">
					<button type="button" class="btn btn-default btn-sm btn-move-right"><i class="fa fa-angle-right"></i></button>
					<button type="button" class="btn btn-default btn-sm btn-move-left"><i class="fa fa-angle-left"></i></button>
					<button type="button" class="btn btn-default btn-sm btn-move-all-right"><i class="fa fa-angle-double-right"></i></button>
					<button type="button" class="btn btn-default btn-sm btn-move-all-left"><i class="fa fa-angle-double-left"></i></button>
				</div>
			</div>
			<div class="us-box us-right">
				<ul class="list-inline">
					<li><a href="#" onclick="return false;" class="text-muted small btn-select-all-users"><?php echo JText::_('JGLOBAL_SELECTION_ALL')?></a></li>
					<li><a href="#" onclick="return false;" class="text-muted small btn-deselect-all-users"><?php echo JText::_('JGLOBAL_SELECTION_NONE')?></a></li>
				</ul>
				<div class="list-group users-list users-selected"></div>
				<select id="users_selected" name="jform[users][]" size="10" class="chosen-disabled" multiple="multiple" style="display: none;"></select>
			</div>
		</div>
	</div>
	
	<div class="actions">
		<button id="btn-invite-registered-users" type="button" class="btn btn-primary" 
			onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.users', 'onBeforeInviteRegisteredUsers', 'onAfterInviteRegisteredUsers'); return false;">
			<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SEND_INVITATION');?>
		</button>
	</div>
</div>