<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';

$input		= JFactory::getApplication()->input;
$data		= $displayData['data'];
$params 	= $data->params;
$state		= $data->state;
$theme 		= $params->get('theme', 'default');
$layout		= $input->getCmd('layout', 'consolidated');
$language   = JFactory::getLanguage()->getTag();
$language   = substr($language, 0, strpos($language, '-'));
?>
<div class="report-filter">
	<div class="card bg-<?php echo $theme;?> mb-3">
		<div class="card-header">
			<h4 class="card-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_TITLE');?></h4>
		</div>
		<div class="card-body">
			<div class="date-filter form-inline mb-3" style="position: relative;">
				<div class="input-append input-group datetime mr-3">
					<input type="text" name="start_date" class="form-control" value="<?php echo $this->escape($state->get($layout.'.start_date', ''));?>" 
						placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_START_DATE');?>"
						data-language="<?php echo $language;?>"
						data-format="Y-m-d H:i:s">
				</div>
				<div class="input-append input-group datetime">
					<input type="text" name="end_date" class="form-control" value="<?php echo $this->escape($state->get($layout.'.end_date', ''));?>" 
						placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_FILTER_END_DATE');?>"
						data-language="<?php echo $language;?>"
						data-format="Y-m-d H:i:s">
				</div>
			</div>
			<div class="custom-answers-filter">
				<div class="form-horizontal">
					<div class="form-group">
						<label for="inputCustomAnswersCount"><?php echo JText::_('COM_COMMUNITYSURVEYS_CUSTOM_ANSWERS_COUNT');?></label>
						<select id="inputCustomAnswersCount" name="num_custom_answers" class="form-control">
							<option value="5"<?php echo $state->get($layout.'.num_custom_answers') == 5 ? ' selected="selected"' : '';?>>5</option>
							<option value="10"<?php echo $state->get($layout.'.num_custom_answers') == 10 ? ' selected="selected"' : '';?>>10</option>
							<option value="20"<?php echo $state->get($layout.'.num_custom_answers') == 20 ? ' selected="selected"' : '';?>>20</option>
							<option value="25"<?php echo $state->get($layout.'.num_custom_answers') == 25 ? ' selected="selected"' : '';?>>25</option>
							<option value="50"<?php echo $state->get($layout.'.num_custom_answers') == 50 ? ' selected="selected"' : '';?>>50</option>
							<option value="100"<?php echo $state->get($layout.'.num_custom_answers') == 100 ? ' selected="selected"' : '';?>>100</option>
							<option value="500"<?php echo $state->get($layout.'.num_custom_answers') == 500 ? ' selected="selected"' : '';?>>500</option>
						</select>
					</div>
				</div>
			</div>
			<div class="questions-filter">
				<p><?php echo JText::_('COM_COMMUNITYSURVEYS_QUESTIONS_FILTER_DESC');?></p>
				<div id="filter-rules-builder"></div>
				<span style="display: none;" id="filter-rules-json"><?php echo $data->filter_rules;?></span>
				<span style="display: none;" id="filter-rules-basic"><?php echo $state->get('advancedfilter.conditions');?></span>
			</div>
						
			<div class="actions margin-top-10">
				<input type="hidden" id="filter_conditions" name="filter_conditions" value="">
				<button type="reset" class="btn btn-default"><?php echo JText::_('COM_COMMUNITYSURVEYS_CLEAR_FILTER');?></button>
				<button type="submit" class="btn btn-primary" onclick="return CjSurveyApi.buildRules();">
					<?php echo JText::_('COM_COMMUNITYSURVEYS_APPLY_FILTER');?>
				</button>
			</div>
		</div>
	</div>
</div>
