<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$colors 			= array('#3366CC', '#DC3912', '#FF9900', '#109618', '#0099C6', '#DD4477', '#66AA00', '#AAAA11', '#994499', '#E67300');
$strColors 			= $params->get('chart_colors', '#3366CC,#DC3912,#FF9900,#109618,#0099C6,#DD4477,#66AA00,#AAAA11,#994499,#E67300');
if(!empty($strColors))
{
	$colors = explode(',', $strColors);
}
?>
<div class="table-responsive grid-reports-table" style="display: none;">
	<table class="table table-hover table-bordered table-striped margin-bottom-20 grid-table">
		<thead>
			<tr>
				<td></td>
				<?php 
				foreach($item->columns as $column)
				{
					?>
					<td class="center"><?php echo $this->escape($column->title);?></td>
					<?php 
				}
				?>
			</tr>
		<thead>
		<tbody>
			<?php
			foreach($item->answers as $answer)
			{
				if($answer->answer_type != 'x')
				{
					continue;
				}
				?>
				<tr>
					<td><?php echo $this->escape($answer->title);?></td>
					<?php
					foreach($item->columns as $column)
					{
						$votes = 0;
						foreach ($item->responses as $response)
						{
							if($response->answer_id == $answer->id && $response->column_id == $column->id)
							{
								$votes += $response->votes;
							}
						}
						?>
						<td class="text-center"><?php echo $votes;?></td>
						<?php 
					}
					?>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
</div>

<div class="row grid-reports-charts">
	<?php 
	foreach ($item->answers as $answer)
	{
		$stats				= array();
		$stats[] = '[\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER').'\',\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES').'\']';
		
		foreach ($item->columns as &$column)
		{
			$votes = 0;
			foreach ($item->responses as $response)
			{
				if($response->answer_id == $answer->id && $response->column_id == $column->id)
				{
					$votes = $votes + $response->votes;
				}
			}
			
			$stats[] = '["'.$this->escape($column->title).'",'.$votes.']';
		}
		reset($item->answers);
		?>
		<div class="col-lg-4 col-md-4 col-xs-1">
			<p style="text-align: center; margin: 10px 0;"><strong><?php echo $this->escape($answer->title);?></strong></p>
			<div id="chart-<?php echo $item->id . '-' . $answer->id;?>" class="chartarea margin-bottom-10"></div>
			<script type="text/javascript">
				google.setOnLoadCallback(drawChart<?php echo $item->id;?>);
				function drawChart<?php echo $item->id;?>() 
				{
					var data = google.visualization.arrayToDataTable([<?php echo implode(',', $stats);?>]);
					var options = {
							'legend': {position: 'right', textStyle: {color: 'blue', fontSize: 11}}, 
							'width': '100%', 
							'chartArea' :{left:20, top:0, width:'100%', height:'100%'}, 
							'colors': ['<?php echo implode('\',\'', $colors);?>'], pieHole: 0.4};
					var chart = new google.visualization.PieChart(document.getElementById('chart-<?php echo $item->id . '-' . $answer->id;?>'));
					chart.draw(data, options);
				}
			</script>
		</div>
		<?php 
	}
	?>
</div>

<?php 
if($params->get('show_text_answers', 1) == 1 && !empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ($item->textResponses as $response)
			{
			?>
			<tr>
				<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
				<td><?php echo $response->free_text;?></td>
			</tr>
			<?php
			}
			?>
			<tr>
				<td colspan="2">
					<a href="#" onclick="document.surveyForm.qid.value=<?php echo $item->id;?>; CjSurveyApi.submitAjaxForm(this, '#surveyForm', 'reports.getanswers', 'onBeforeGetTextAnswers', 'onAfterGetTextAnswers'); return false">
						<i class="fa fa-comments"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_ALL_RESPONSES');?>
					</a>
				</td>
			</tr>
		</tbody>
	</table>
	<?php
}
