<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];

foreach ($item->answers as &$answer)
{
	$answer->votes = 0;
	$answer->value = 0;
	foreach ($item->responses as $response)
	{
		if($answer->id == $response->answer_id)
		{
			$answer->votes = $answer->votes + $response->votes;
			$answer->value = $answer->value + ($response->column_id * $response->votes);
		}
	}
}
reset($item->answers);
unset($answer);
$max_rating = $item->params->get('num_rating_stars', 5);
?>
<table class="table table-striped table-hover">
	<thead>
		<tr>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTIONS')?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RATING')?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_AVERAGE')?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES')?></th>
		</tr>
	</thead>
	<tbody>
		<?php 
		foreach ($item->answers as $answer)
		{
			$score = ($answer->votes > 0 && $max_rating > 0) ? (float) round($max_rating * $answer->value / ($answer->votes * $max_rating), 2) : 0;
			?>
			<tr>
				<td><?php echo $this->escape($answer->title);?></td>
				<td>
					<select size="1" data-toggle="rating" data-score="<?php echo (float) $score;?>" data-theme="fontawesome-stars-o" class="chosen-disabled">
    					<?php for($i = 1; $i <= $max_rating; $i++): ?>
						<option value="<?php echo $i;?>"><?php echo $i;?></option>
						<?php endfor;?>
    				</select>
				</td>
				<td><?php echo $score;?></td>
				<td><?php echo $answer->votes;?></td>
			</tr>
			<?php 
		}
		?>
	</tbody>
</table>

<?php 
if($params->get('show_text_answers', 1) == 1 && !empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ($item->textResponses as $response)
			{
			?>
			<tr>
				<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
				<td><?php echo $response->free_text;?></td>
			</tr>
			<?php
			}
			?>
			<tr>
				<td colspan="2">
					<a href="#" onclick="document.surveyForm.qid.value=<?php echo $item->id;?>; CjSurveyApi.submitAjaxForm(this, '#surveyForm', 'reports.getanswers', 'onBeforeGetTextAnswers', 'onAfterGetTextAnswers'); return false">
						<i class="fa fa-comments"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_VIEW_ALL_RESPONSES');?>
					</a>
				</td>
			</tr>
		</tbody>
	</table>
	<?php
}
