<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$promoterScore		= 0;
$detractorScore		= 0;
$item->votes		= 0;
$scores				= array();

for ($i = 1; $i <= 10; $i++)
{
	$score = 0;
	foreach ($item->responses as $response)
	{
		if($i == $response->answer_id)
		{
			$score = $response->votes;
			$item->votes += $response->votes;
			
			if($i < 7)
			{
				$detractorScore = $detractorScore + $response->votes;
			}
			
			if($i > 8)
			{
				$promoterScore = $promoterScore + $response->votes;
			}
			
			break;
		}
	}
	
	$scores[] = $score;
}
reset($item->answers);
$promoterPct = $item->votes > 0 ? round($promoterScore / $item->votes * 100) : 0;
$detractorPct = $item->votes > 0 ? round($detractorScore / $item->votes * 100) : 0;
$nps = $promoterPct - $detractorPct;
?>
<div class="card-body nps-container">
	<div class="chart-container" style="position: height:10vh; width:25vw">
		<canvas class="nps-chart"></canvas>
	</div>
	
	<h4><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_NPS_VALUE', $nps);?></h4>
	<span class="label label-success"><?php echo $promoterPct;?>%</span>&nbsp;<?php echo JText::_('COM_COMMUNITYSURVEYS_PROMOTERS')?>&nbsp;-&nbsp;
	<span class="label label-important"><?php echo $detractorPct;?>%</span>&nbsp;<?php echo JText::_('COM_COMMUNITYSURVEYS_DETRACTORS')?>

	<div style="display: none">
		<span class="nps-labels">[1,2,3,4,5,6,7,8,9,10]</span>
		<span class="nps-scores"><?php echo json_encode($scores);?></span>
	</div>
</div>
