<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$checked			= false;
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));

$range_selection = '';
if( $item->min_selections > 0 && $item->max_selections > 0 && $item->max_selections >= $item->min_selections )
{
    $range_selection = ' minselect="'.$item->min_selections.'" maxselect="'.$item->max_selections.'" data-field-type="grid"';
}
else if( $item->min_selections > 0 )
{
    $range_selection = ' minselect="'.$item->min_selections.'" data-field-type="grid"';
}
else if( $item->max_selections > 0 )
{
    $range_selection = ' minselect=0 maxselect="'.$item->max_selections.'" data-field-type="grid"';
}

$span = count($item->columns) > 4 ? 1 : 2;
$firstSpan = 12 - count($item->columns) * $span;
?>
<div class="panel-body grid-table">
	<div class="row d-none d-md-flex grid-row">
		<div class="col-md-<?php echo $firstSpan;?>">&nbsp;</div>
		<?php foreach ($item->columns as $column):?>
		<div class="col-md-<?php echo $span;?> align-center-desktop"><strong><?php echo $this->escape($column->title);?></strong></div>
		<?php endforeach;?>
	</div>
	
	<?php foreach($item->answers as $i=>$answer):?>
	<div class="row grid-row">
		<div class="col-md-<?php echo $firstSpan;?>"><strong><?php echo $this->escape($answer->title);?></strong></div>
		<?php 
		foreach ($item->columns as $j=>$column)
		{
		    $checked = false;
		    $rules = '';
		    
		    foreach ($item->responses as $response)
		    {
		        if(($response->answer_id == $answer->id) && ($response->column_id == $column->id))
		        {
		            $checked = true;
		        }
		        else if(!empty($response->free_text))
		        {
		            $free_text = CjLibUtils::escape($response->free_text);
		        }
		    }
		    
		    if(isset($item->rule_selected[$answer->id][$column->id]))
		    {
		        $rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id][$column->id]).'"';
		    }
		    ?>
		    <div class="col-md-<?php echo $span;?> align-center-desktop">
		    	<div class="form-check">
    				<label class="form-check-label" for="answer-<?php echo $answer->id . '-' . $column->id?>">
    					<input type="checkbox" name="answer-<?php echo $item->id.'-'.$answer->id;?>[]" 
    						value="<?php echo $column->id;?>"<?php echo $required.($checked ? ' checked="checked"' : '');?> <?php echo $range_selection;?>
    						id="answer-<?php echo $answer->id . '-' . $column->id?>"
    						class="form-check-input mgc mgc-primary"
    						<?php echo $rules;?>
    						role="radio"
    						aria-checked="<?php echo $checked ? 'true' : 'false';?>"
    						aria-label="<?php echo $this->escape(strip_tags($column->title));?>"
    						tabindex="<?php echo $j ? '-1' : '0';?>"/> <span class="grid-label-xs"><?php echo $this->escape($column->title);?></span>
    				</label>
    			</div>
		    </div>
		    <?php
		}
		?>
	</div>
	<?php endforeach;?>
</div>

<?php
if($item->custom_choice == 1)
{
	?>
	<ul class="list-group no-margin-left">
		<li class="list-group-item">
			<input type="text" name="free-text-<?php echo $item->id;?>" class="input-xlarge" 
				value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-label="<?php echo $customAnswerPH;?>">
		</li>
	</ul>
	<?php 
}