<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$app                = JFactory::getApplication();
$data				= $displayData['data'];
$params  			= $data->item->params;
$theme 				= $params->get('theme', 'default');
$layout 			= $params->get('ui_layout', 'default');
$displayContinue 	= !empty($data->response) && $data->pagination->getNextPageId();
$surveyUrl			= CommunitySurveysHelperRoute::getSurveysRoute();
$currPageNum		= !empty($data->pagination) ? $data->pagination->getCurrPageNum() : 1;

// echo '<pre>'.var_export($data->pagination, true).'</pre>';
?>
<form id="adminForm" name="adminForm" action="<?php echo JRoute::_($surveyUrl);?>" enctype="multipart/form-data" method="post">

	<?php 
	$customHeader = strip_tags($data->item->custom_header);
	if(!empty($customHeader))
	{
		?>
		<div class="survey-custom-header">
			<?php 
			JPluginHelper::importPlugin('content');
			$data->item->text = $data->item->custom_header;
			$app->triggerEvent('onContentPrepare', array('com_communitysurveys.response',	&$data->item,	&$params, 0));
			$data->item->custom_header = $data->item->text;
			
			echo $data->item->custom_header;
			?>
		</div>
		<?php 
		}
	?>

	<div class="survey-pagination">
		<?php
		if(isset($data->pagination))
		{ 
			echo SurveyHelper::renderLayout($layout.'.response.pagination', array('data'=>$data));
		}
		?>
	</div>
	
	<div class="questions">
		<?php 
		if(!empty($data->questions))
		{
			foreach ($data->questions as $question)
			{
				echo SurveyHelper::renderLayout($layout.'.response.question', array('data'=>$data, 'question'=>$question));
			}
		}
		
		if(!empty($data->item->secret))
		{
		    ?>
		    <div class="card bg-<?php echo $theme?>">
		    	<div class="card-body text-center">
		    		<label><?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_SECRET_KEY_TO_CONTINUE');?></label>
		    		<input type="text" name="secret_key" class="input-medium"/>
		    	</div>
			</div>
			<?php
		}
		
		////////////// DO NOT REMOVE BELOW HIDDEN FIELDS //////////
		?>
		<input type="hidden" name="pid" value="<?php echo $data->pageId;?>">
		<input type="hidden" name="rid" value="<?php echo !empty($data->response) ? $data->response->response_id : 0;?>">
		<?php //////// DO NOT REMOVE BELOW HIDDEN FIELDS ///////// ?>
	</div>
	
	<?php if($params->get('enable_captcha', 0)):?>
	<div class="captcha-form center text-center margin-bottom-10 margin-top-10">
		<?php 
		JPluginHelper::importPlugin('captcha');
		$recaptcha = $app->triggerEvent('onDisplay', array(null, 'cjsurvey_captcha', 'class=""'));
    	echo (isset($recaptcha[0])) ? $recaptcha[0] : '';
    	?>
    	<input type="hidden" name="captcha-field" value="1">
	</div>
	<?php endif;?>
	
	<div class="alert alert-warning messages" style="display: none;"></div>
	<div class="alert alert-danger alert-validation-error" style="display: none;">
		<i class="fa fa-exclamation-triangle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_ERROR_RESPONSE_CONTAINS_ERRORS')?>
	</div>
	
	<div class="card bg-<?php echo $theme;?> mb-3 survey-navigation">
		<div class="card-body text-center">
		
			<?php if($params->get('show_cancel_button')):?>
			<a class="btn btn-default" href="<?php echo $surveyUrl;?>">
				<?php echo JText::_('JCANCEL');?>
			</a>
			<?php endif;?>
			
			<?php if($params->get('show_save_button')):?>
			<button type="button" class="btn btn-save" <?php echo (!empty($data->response) && $displayContinue) ? '' : 'style="display: none;"';?>
				onclick="CjSurveyApi.submitAjaxForm(this, '#adminForm', 'response.save', 'onBeforeApplyResponse', 'onAfterApplyResponse');">
				<i class="fa fa-save"></i> <?php echo JText::_('JSAVE');?>
			</button>
			<?php endif;?>
			
			<?php if($params->get('show_prev_button')):?>
			<button type="button" class="btn btn-default btn-previous" style="display: none;" <?php echo $currPageNum < 2 ? 'style="display: none;"' : ''?>
				onclick="CjSurveyApi.submitAjaxForm(this, '#adminForm', 'response.previous', 'onBeforeSaveResponse', 'onAfterSaveResponse');">
				<?php echo JText::_('JPREVIOUS');?>
			</button>
			<?php endif;?>
			
			<button type="button" class="btn btn-primary btn-next" <?php echo (!empty($data->response) && $displayContinue) ? '' : 'style="display: none;"';?>
				onclick="CjSurveyApi.submitAjaxForm(this, '#adminForm', 'response.next', 'onBeforeSaveResponse', 'onAfterSaveResponse');">
				<i class="fa fa-check"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_CONTINUE');?>
			</button>
			
			<button type="button" class="btn btn-primary btn-finish" <?php echo (empty($data->response) || $displayContinue) ? 'style="display: none;"' : '';?>
				onclick="CjSurveyApi.submitAjaxForm(this, '#adminForm', 'response.next', 'onBeforeSaveResponse', 'onAfterSaveResponse');">
				<i class="fa fa-check"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_FINISH');?>
			</button>
			
			<?php if(empty($data->response)):?>
			<button type="button" class="btn btn-primary btn-create" 
				onclick="CjSurveyApi.submitAjaxForm(this, '#adminForm', 'response.create', 'onBeforeCreateResponse', 'onAfterCreateResponse');">
				<?php echo JText::_('COM_COMMUNITYSURVEYS_START_SURVEY');?>
			</button>
			<?php endif;?>
		</div>
	</div>

	<input type="hidden" name="id" value="<?php echo $data->item->id?>">	
	<input type="hidden" name="cid" value="<?php echo $data->item->id?>">
	<input type="hidden" name="key" value="<?php echo $data->key;?>">
	<input type="hidden" name="skey" value="<?php echo $data->skey;?>">
	<input type="hidden" name="option" value="com_communitysurveys">
	<input type="hidden" name="task" value="response.create">
	<?php echo JHtml::_('form.token'); ?>
</form>

<div style="display: none;">
	<input type="hidden" id="cjpageid" value="survey_response">
	<div id="default_error_required"><?php echo JText::_('COM_COMMUNITYSURVEYS_ERROR_QUESTION_MANDATORY');?></div>
	<div id="progress-message"><h3><i class="fa fa-spinner fa-spin"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PROGRESS_LOADING_MESSAGE');?></h3></div>
	<div id="date_labels1"><?php echo JText::_('COM_COMMUNITYSURVEYS_DATE_LABELS1')?></div>
	<div id="date_labels2"><?php echo JText::_('COM_COMMUNITYSURVEYS_DATE_LABELS2')?></div>
	<div id="rating_hints"><?php echo JText::_('COM_COMMUNITYSURVEYS_RATING_HINTS_TEXT')?></div>
	<div id="cancel_rating_hint"><?php echo JText::_('COM_COMMUNITYSURVEYS_CANCEL_RATING_HINT_TEXT')?></div>
	<div id="msg_validation_min_answers_required"><?php echo JText::_('COM_COMMUNITYSURVEYS_MIN_ANSWERS_REQUIRED')?></div>
	<div id="msg_validation_max_answers_required"><?php echo JText::_('COM_COMMUNITYSURVEYS_MAX_ANSWERS_REQUIRED')?></div>
	<?php echo JEditor::getInstance($app->get('editor'))->display('dummyeditor', '', '100%', '200px', 23, 5, true, 'dummyeditor' );?>
</div>