<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();
$data = $displayData['data'];
?>
<table class="table table-hover table-condensed table-striped contact-groups-table">
	<thead>
		<tr>
			<th width="3%"><input type="checkbox" class="checkall"></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_GROUP_NAME');?></th>
			<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTACTS');?></th>
			<th width="5%"><?php echo JText::_('JGRID_HEADING_ID');?></th>
			<th width="5%"><i class="fa fa-users"></i></th>
			<th width="5%"><i class="fa fa-remove"></i></th>
		</tr>
	</thead>
	<tbody>
		<?php if(!empty($data->cgroups)):?>
			<?php foreach ($data->cgroups as $group):?>
			<tr>
				<td>
					<input type="checkbox" class="checkbox" name="jform[cgroup_id][]" value="<?php echo $group->id?>">
				</td>
				<td>
					<?php echo $this->escape($group->name);?>
				</td>
				<td>
					<?php echo $group->contacts;?>
				</td>
				<td>
					<?php echo $group->id;?>
				</td>
				<td>
					<a class="btn btn-mini btn-primary btn-assign-contacts" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ASSIGN_CONTACTS');?>" 
						onclick="return false;" data-toggle="tooltip">
						<i class="fa fa-users"></i>
					</a>
				</td>
				<td>
					<a class="btn btn-mini btn-danger" title="<?php echo JText::_('JACTION_DELETE');?>" data-toggle="tooltip" href="#"
						onclick="document.inviteForm.cid.value=<?php echo $group->id;?>;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.deletegroup', 'onBeforeDeleteContactGroup', 'onAfterDeleteContactGroup'); return false;">
						<i class="fa fa-remove"></i>
					</a>
				</td>
			</tr>
			<?php endforeach;?>
		<?php else:?>
		<tr>
			<td colspan="4"><?php echo JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH')?></td>
		</tr>
		<?php endif;?>
	</tbody>
</table>

<div class="contact-groups-listbox" style="display: none;">
	<select id="jform_assign_group" name="jform[assign_group]" class="chosen-disabled">
		<option><?php echo JText::_('JGLOBAL_SELECT_AN_OPTION');?></option>
		<?php if(!empty($data->cgroups)):?>
			<?php foreach ($data->cgroups as $group):?>
			<option value="<?php echo $group->id;?>"><?php echo $this->escape($group->name);?></option>
			<?php endforeach;?>
		<?php endif;?>
	</select>
</div>

<div class="actions">
	<button id="btn-add-contact-group" type="button" class="btn btn-primary" data-toggle="modal" data-target="#cgroup-form-modal">
		<i class="fa fa-plus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_CONTACT_GROUP');?>
	</button>
	<button id="btn-invite-contact-groups" type="button" class="btn btn-primary" 
		onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.contactgroups', 'onBeforeInviteContactGroups', 'onAfterInviteContactGroups'); return false;">
		<i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SEND_INVITATION');?>
	</button>
</div>