<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$data		= $displayData['data'];
$item		= $data->item;
$surveyUrl 	= CommunitySurveysHelperRoute::getSurveyRoute($item->id, $item->catid, $item->language);
?>
<div class="survey-urls-intro"><?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_MANUAL_UNIQUE_URLS_INTRO');?></div>

<div class="well well-small">
	<div class="form-search">
		<input type="text" name="num_urls" value="5" maxlength="2" class="input-mini">
		<button type="button" class="btn btn-primary"
			onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.createurls', 'onBeforeCreateUniqueUrls', 'onAfterCreateUniqueUrls'); return false;">
			<?php echo JText::_('COM_COMMUNITYSURVEYS_CREATE_URLS');?>
		</button>
		
		<a class="btn btn-success" href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=invite.exporturls&id='.$item->id);?>" target="_blank">
        	<i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_EXPORT')?>
        </a>
	</div>
</div>

<table class="table table-hover table-condensed table-striped">
	<thead>
		<tr>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SURVEY_URL');?></th>
			<th width="20%"><?php echo JText::_('JDATE');?></th>
			<th width="10%" style="text-align: center;"><?php echo JText::_('JSTATUS');?></th>
		</tr>
	</thead>
	<tbody>
		<?php if(!empty($data->keys)):?>
			<?php foreach ($data->keys as $key):?>			
			<tr>
				<td>
					<?php echo SurveyHelper::buildSefSurveyUrl($surveyUrl.'&key='.$key->key_name, true, -1);?>
				</td>
				<td>
					<?php echo $key->created;?>
				</td>
				<td style="text-align: center;">
					<?php if($key->response_status == 0):?>
					<span data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSE_YET_TO_START');?>">
						<i class="fa fa-circle-thin"></i>
					</span>
					<?php elseif($key->response_status == 1):?>
					<span data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSE_FINALIZED');?>">
						<i class="fa fa-check-circle"></i>
					</span>
					<?php elseif($key->response_status == 2):?>
					<span data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSE_PENDING');?>">
						<i class="fa fa-spinner fa-spin"></i>
					</span>
					<?php endif;?>
				</td>
			</tr>
			<?php endforeach;?>
		<?php else:?>
		<tr>
			<td colspan="3"><?php echo JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH')?></td>
		</tr>
		<?php endif;?>
	</tbody>
</table>