<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 		= $displayData['item'];
$colors 	= array( "#006159", "#00867b", "#00a294", "#00b8a9", "#00ccbb", "#44d9cd", "#77e3da", "#a0ece5", "#c4f3ef", "#e3f9f7" );

foreach ($item->answers as &$answer)
{
	$answer->votes = 0;
	$answer->score = 0;
	$answer->distribution = array();
	foreach ($item->responses as $response)
	{
		if($response->answer_id == $answer->id)
		{
			$answer->votes = $answer->votes + $response->votes;
			$answer->score = $answer->score + ( ((int) $item->params->get('rank_weight_'.$response->column_id, 1)) * $response->votes );
			$answer->distribution[$response->column_id] = ((int) $item->params->get('rank_weight_'.$response->column_id, 1)) * $response->votes;
		}
	}
}

// sort answers by score
usort($item->answers, function($a, $b)
{
	return strcmp($b->score, $a->score);
});
?>
<table class="table table-striped table-hover">
	<thead>
		<tr>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RANK');?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ITEM');?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_DISTRIBUTION');?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SCORE');?></th>
			<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_NUM_RANKINGS');?></th>
		</tr>
	</thead>
	<tbody>
	<?php 
	foreach ($item->answers as $i => &$answer)
	{
		ksort($answer->distribution, SORT_NUMERIC);
		?>
		<tr>
			<td><?php echo $i + 1?></td>
			<td><?php echo $this->escape($answer->title)?></td>
			<td>
				<div class="progress">
					<?php foreach ($answer->distribution as $rank=>$dist):?>
					<div class="bar bar-default" title="<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_RANK_NUM', $rank) . ' ('.$dist.')'?>" data-toggle="tooltip"
						style="width: <?php echo round($dist * 100 / $answer->score, 3)?>%; background-color: <?php echo $colors[$rank % 10]?>; background-image: none;"></div>
					<?php endforeach;?>
				</div>
			</td>
			<td><?php echo $answer->score?></td>
			<td><?php echo $answer->votes?></td>
		</tr>
		<?php 
	}
	?>
	</tbody>
</table>
