<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

JHtml::_('formbehavior.chosen', 'select');

$document	= JFactory::getDocument();
$data		= $displayData['data'];
$report		= $data->report;

if($report && count($report) > 0)
{
	$document->addScript('https://www.google.com/jsapi');
	$document->addScriptDeclaration('google.load("visualization", "1", {packages:["corechart"]});');
	$stats = array();
	$stats[] = '[\''.JText::_('COM_COMMUNITYSURVEYS_OS').'\',\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES').'\']';
	
	foreach ($report as $rep)
	{
		$stats[] = '["'.$this->escape($rep['platform']).'",'.$rep['count'].']';
	}
	?>
	<div class="row-fluid platform-report">
		<div class="span8">
			<div id="platform-chart" style="width: 100%; height: 400px; margin-bottom: 20px;"></div>
			<script type="text/javascript">
			<!--
			google.setOnLoadCallback(drawPlatformMap);
			function drawPlatformMap() 
			{
				var data = google.visualization.arrayToDataTable([<?php echo implode(',', $stats);?>]);
				var options = {};
				var chart = new google.visualization.PieChart(document.getElementById('platform-chart'));
				chart.draw(data, options);
			    jQuery('select').chosen();
			}		
			//-->
			</script>
		</div>
		<div class="span4">
			<div class="table-responsive">
				<table class="table table-striped table-hover table-condensed">
					<thead>
						<tr>
							<th><?php echo JText::_('COM_COMMUNITYSURVEYS_OS');?></th>
							<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ($report as $rep):?>
						<tr>
							<td><?php echo $this->escape($rep['platform']);?></td>
							<td><?php echo $rep['count'];?></td>
						</tr>
						<?php endforeach;?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<?php 
}
else 
{
	?>
	<p class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS');?></p>
	<?php
}
?>
