<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$free_text 			= '';
?>
<ul class="list-group no-margin-left survey-result-question">
	<?php
	if(count($item->answers))
	{
		foreach ($item->answers as $answer)
		{
			$selected = false;
			if(!empty($item->responses))
			{
				foreach ($item->responses as $response)
				{
					if($response->answer_id == $answer->id)
					{
						$selected = true;
					}
				}
			}
			?>
			<li class="<?php echo $item->orientation == 'IL' ? '' : 'list-group-item ';?>choice-answer<?php echo $selected ? ' selected-answer' : '';?>">
				<?php
				if($selected)
				{
					?>
					<i class="fa fa-check-square-o" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>"></i>
					<?php
				}
				else
				{
					?>
					<i class="fa fa-square-o text-muted"></i>
					<?php
				}
				
				echo $this->escape($answer->title);
				
				if($selected)
				{
					?>
					<span class="text-success">(<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER')?>)</span>
					<?php
				}
				?>
			</li>
			<?php 
		}
	}
	else
	{
		if(!empty($item->responses))
		{
			foreach ($item->responses as $response)
			{
				if(!empty($response->free_text))
				{
					$free_text = $response->free_text;
					break;
				}
			}
		}
		?><li class="list-group-item choice-answer"><?php echo $this->escape($free_text);?></li><?php 
	}
	?>
</ul>